/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

public class IdempotentMessageValidatorNamespaceHandlerTestCase
extends AbstractIntegrationTestCase {
    private static final String KEY = "theKey";
    private static final String VALUE = "theValue";
    private ObjectStore objectStore;
    @Rule
    public SystemProperty customObjectStore = new SystemProperty("customObjectStore", "customObjectStore");

    protected String getConfigFile() {
        return "org/mule/test/config/idempotent-message-validator-config.xml";
    }

    @Test
    public void testCustomObjectStore() throws Exception {
        this.objectStore = muleContext.getObjectStoreManager().getObjectStore(this.customObjectStore.getValue());
        this.objectStore.store(KEY, (Serializable)((Object)VALUE));
        this.testPojoObjectStore("customObjectStoreFlow");
    }

    private void testPojoObjectStore(String flowName) throws Exception {
        Processor filter = this.idempotentMessageFilterFromFlow(flowName);
        ObjectStore store = this.getObjectStore(filter);
        Assert.assertThat((Object)store.contains(KEY), (Matcher)Matchers.equalTo((Object)true));
    }

    private Processor idempotentMessageFilterFromFlow(String flowName) throws Exception {
        FlowConstruct flow = (FlowConstruct)this.registry.lookupByName(flowName).get();
        Assert.assertTrue((boolean)(flow instanceof Flow));
        Flow simpleFlow = (Flow)flow;
        List processors = simpleFlow.getProcessors();
        Assert.assertEquals((long)1L, (long)processors.size());
        Processor firstMP = (Processor)processors.get(0);
        Assert.assertThat((Object)firstMP.getClass().getName(), (Matcher)Matchers.equalTo((Object)"org.mule.runtime.core.internal.routing.IdempotentMessageValidator"));
        return firstMP;
    }

    private ObjectStore getObjectStore(Processor router) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = router.getClass().getMethod("getObjectStore", new Class[0]);
        return (ObjectStore)method.invoke((Object)router, new Object[0]);
    }
}

