/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.test.core.context.notification.RestrictedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node
implements RestrictedNode {
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int EMPTY = 2;
    private Class clazz = null;
    private Notification.Action action;
    private String id;
    private boolean isIdDefined = false;
    private boolean nodeOk = false;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set parallel = new HashSet();
    private LinkedList serial = new LinkedList();

    public Node(Class clazz, Notification.Action action, String id) {
        this(clazz, action);
        this.id = id;
        this.isIdDefined = true;
    }

    public Node(Class clazz, Notification.Action action) {
        this.clazz = clazz;
        this.action = action;
    }

    public Node() {
        this.nodeOk = true;
    }

    public Node parallel(RestrictedNode node) {
        this.parallel.add(node);
        return this;
    }

    @Override
    public RestrictedNode serial(RestrictedNode node) {
        this.serial.addLast(node);
        return this;
    }

    @Override
    public int match(AbstractServerNotification notification) {
        Node child;
        Iterator children;
        if (!this.nodeOk) {
            if (this.testLocal(notification)) {
                this.nodeOk = true;
                return 0;
            }
            return 1;
        }
        if (this.parallel.size() > 0) {
            children = this.parallel.iterator();
            block10: while (children.hasNext()) {
                child = (Node)children.next();
                switch (child.match(notification)) {
                    case 0: {
                        return 0;
                    }
                    case 2: {
                        children.remove();
                        continue block10;
                    }
                    case 1: {
                        continue block10;
                    }
                }
                throw new IllegalStateException("Bad return from child");
            }
        }
        if (this.parallel.size() > 0) {
            return 1;
        }
        if (this.serial.size() > 0) {
            children = this.serial.iterator();
            block11: while (children.hasNext()) {
                child = (Node)children.next();
                switch (child.match(notification)) {
                    case 0: {
                        return 0;
                    }
                    case 2: {
                        children.remove();
                        continue block11;
                    }
                    case 1: {
                        return 1;
                    }
                }
                throw new IllegalStateException("Bad return from child");
            }
        }
        if (this.serial.size() > 0) {
            return 1;
        }
        return 2;
    }

    private boolean testLocal(AbstractServerNotification notification) {
        return this.clazz.equals(notification.getClass()) && this.action.equals(notification.getAction()) && (!this.isIdDefined || null == this.id && null == notification.getResourceIdentifier() || null != this.id && this.id.equals(notification.getResourceIdentifier()));
    }

    @Override
    public boolean contains(Class clazz, Notification.Action action) {
        if (null != this.clazz && this.clazz.equals(clazz) && this.action.equals(action)) {
            return true;
        }
        Iterator children = this.parallel.iterator();
        while (children.hasNext()) {
            if (!((RestrictedNode)children.next()).contains(clazz, action)) continue;
            return true;
        }
        children = this.serial.iterator();
        while (children.hasNext()) {
            if (!((RestrictedNode)children.next()).contains(clazz, action)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RestrictedNode getAnyRemaining() {
        RestrictedNode any;
        if (!this.nodeOk) {
            return this;
        }
        Iterator children = this.parallel.iterator();
        while (children.hasNext()) {
            any = ((RestrictedNode)children.next()).getAnyRemaining();
            if (null == any) continue;
            return any;
        }
        children = this.serial.iterator();
        while (children.hasNext()) {
            any = ((RestrictedNode)children.next()).getAnyRemaining();
            if (null == any) continue;
            return any;
        }
        return null;
    }

    @Override
    public boolean isExhausted() {
        return null == this.getAnyRemaining();
    }

    @Override
    public Class getNotificationClass() {
        return this.clazz;
    }

    public String toString() {
        return this.clazz + ": " + this.action + (this.isIdDefined ? ": " + this.id : "");
    }
}

