/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.Serializable;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Sources")
@Story(value="Watermark")
public class WatermarkTestCase
extends AbstractIntegrationTestCase {
    private static final String LAST_WATERMARK_KEY = "lastWatermark";
    private static final String WATERMARK_KEY = "watermark";
    private ObjectStoreManager objectStoreManager;

    protected String getConfigFile() {
        return "org/mule/test/integration/watermark-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.reset();
        this.objectStoreManager = (ObjectStoreManager)this.registry.lookupByType(ObjectStoreManager.class).get();
    }

    protected void doTearDown() throws Exception {
        this.reset();
    }

    @Test
    public void watermark() throws Exception {
        ObjectStore os = this.objectStoreManager.getObjectStore("watermarkStore");
        Assert.assertThat((Object)os.contains(LAST_WATERMARK_KEY), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)os.contains(WATERMARK_KEY), (Matcher)CoreMatchers.is((Object)false));
        this.runWatermarkFlow();
        Assert.assertThat(this.retrieve(os, LAST_WATERMARK_KEY), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat(this.retrieve(os, WATERMARK_KEY), (Matcher)CoreMatchers.is((Object)4));
        this.runWatermarkFlow();
        Assert.assertThat(this.retrieve(os, LAST_WATERMARK_KEY), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat(this.retrieve(os, WATERMARK_KEY), (Matcher)CoreMatchers.is((Object)9));
    }

    private void runWatermarkFlow() throws Exception {
        this.flowRunner(WATERMARK_KEY).run();
    }

    private <T extends Serializable> T retrieve(ObjectStore<T> os, String key) throws Exception {
        TypedValue typedValue = (TypedValue)os.retrieve(key);
        return (T)((Serializable)typedValue.getValue());
    }

    private void reset() {
        DataSource.ID = 0;
    }

    public static class DataSource
    implements Processor {
        private static int ID = 0;

        public CoreEvent process(CoreEvent event) throws MuleException {
            int top = 5;
            ArrayList<Integer> numbers = new ArrayList<Integer>(5);
            for (int i = ID; i < 5 + ID; ++i) {
                numbers.add(i);
            }
            ID += 5;
            return CoreEvent.builder((CoreEvent)event).message(Message.builder((Message)event.getMessage()).payload(TypedValue.of(numbers)).build()).build();
        }
    }
}

