/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import javax.inject.Inject;
import javax.inject.Named;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.tck.junit4.matcher.metadata.MetadataKeyResultSuccessMatcher;
import org.mule.test.AbstractIntegrationTestCase;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Routers")})
@Story(value="Scatter Gather")
public class RoutesLazyInitTestCase
extends AbstractIntegrationTestCase {
    @Inject
    @Named(value="_muleMetadataService")
    private MetadataService metadataService;
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    protected String getConfigFile() {
        return "lazy-routes.xml";
    }

    @Test
    @Description(value="Resolves metadata from a connector inside of a incomplete Scatter-Gather. In runtime this case fails, but in lazy mode ignores any validation.")
    public void metadataFromElementInsideScatterGather() {
        MetadataResult operationMetadata = this.metadataService.getOperationMetadata(Location.builderFromStringRepresentation((String)"select-inside-scatter-gather/processors/0/route/0/processors/0").build());
        MatcherAssert.assertThat((Object)operationMetadata, (Matcher)MetadataKeyResultSuccessMatcher.isSuccess());
    }

    @Test
    public void singleRouteValidation() {
        this.lazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"select-inside-scatter-gather").build());
    }
}

