/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import javax.transaction.TransactionManager;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Spring 5 handling of null objects")
public class LookupNullObjectTestCase
extends AbstractIntegrationTestCase {
    protected String[] getConfigFiles() {
        return new String[0];
    }

    @Test
    public void noTransactionManagerThroughMuleContext() {
        TransactionManager txManager = muleContext.getTransactionManager();
        Assert.assertThat((Object)txManager, (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void noTransactionManagerThroughRegistryLookup() {
        Assert.assertThat((Object)this.registry.lookupByType(TransactionManager.class).isPresent(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.registry.lookupAllByType(TransactionManager.class), (Matcher)Matchers.hasSize((int)0));
    }
}

