/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.source.SchedulerMessageSource;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Scheduler Service")
@Story(value="Source Management")
@RunnerDelegateTo(value=Parameterized.class)
public class SchedulerInitialStateTestCase
extends AbstractIntegrationTestCase {
    private final List<Component> recordedOnStartMessageSources = new ArrayList<Component>();
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;
    @Inject
    private ConfigurationComponentLocator configurationComponentLocator;
    @Inject
    private TestQueueManager queueManager;
    @Parameterized.Parameter
    public boolean lazyInitEnabled;

    @Parameterized.Parameters(name="lazyInit: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/scheduler-initial-state-management-config.xml";
    }

    public boolean isLazyInitEnabled() {
        return this.lazyInitEnabled;
    }

    public boolean disableXmlValidations() {
        return this.lazyInitEnabled;
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(new ConfigurationBuilder(){

            public void configure(MuleContext muleContext) {
                muleContext.getCustomizationService().overrideDefaultServiceImpl("_muleComponentInitialStateManager", (Object)this.createCustomStateManager());
            }

            private ComponentInitialStateManager createCustomStateManager() {
                return new ComponentInitialStateManager(){

                    public boolean mustStartMessageSource(Component component) {
                        SchedulerInitialStateTestCase.this.recordedOnStartMessageSources.add(component);
                        return component.getLocation().getRootContainerName().equals("runningSchedulerOnStartup");
                    }
                };
            }

            public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
            }
        });
    }

    @Description(value="ComponentInitialStateManager is called during startup for all message sources")
    @Test
    public void startMessageSourceRequestedOnStartup() {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> true);
        Assert.assertThat(this.recordedOnStartMessageSources, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat(this.recordedOnStartMessageSources.stream().map(component -> component.getLocation().getLocation()).collect(Collectors.toList()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"runningSchedulerOnStartup/source", "notRunningSchedulerOnStartup/source"}));
    }

    @Description(value="ComponentInitialStateManager does not allow to start scheduler message sources")
    @Test
    public void verifyMessageSourcesAreNotStarted() throws InterruptedException {
        this.lazyComponentInitializer.initializeComponents(componentLocation -> true);
        SchedulerMessageSource schedulerMessageSource = (SchedulerMessageSource)this.configurationComponentLocator.find(Location.builder().globalName("runningSchedulerOnStartup").addSourcePart().build()).get();
        Assert.assertThat((Object)schedulerMessageSource.isStarted(), (Matcher)CoreMatchers.is((Object)true));
        schedulerMessageSource = (SchedulerMessageSource)this.configurationComponentLocator.find(Location.builder().globalName("notRunningSchedulerOnStartup").addSourcePart().build()).get();
        Assert.assertThat((Object)schedulerMessageSource.isStarted(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.queueManager.read("runningSchedulerOnStartupQueue", 5000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)Matchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)this.queueManager.read("notRunningSchedulerOnStartupQueue", 100L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

