/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.petstore.extension.PetStoreFeatures;
import org.mule.test.petstore.extension.PetStoreOperations;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
@Feature(value="Deployment Configuration")
@Story(value="Feature Flagging")
public class FeatureFlaggedApplicationTestCase
extends AbstractIntegrationTestCase {
    private static final String ECHO_MULE_CONTEXT = "echo-mule-context";
    private static final String ECHO_FEATURE_CONTEXT = "echo-feature-context";
    private static final String SPLITTER_EXCEPTION_FLOW = "splitter-exception";
    private static final String PAYLOAD = "bla";
    private final String flowName;
    private final String minMuleVersion;
    private final Consumer<CoreEvent> assertions;
    @Rule
    public SystemProperty systemProperty;

    @Parameterized.Parameters(name="Feature {0} for minMuleVersion={2} and System Property={3}")
    public static Object[][] parameters() {
        return new Object[][]{{PetStoreFeatures.LEGACY_FEATURE_ONE, ECHO_MULE_CONTEXT, "4.2.2", "true", FeatureFlaggedApplicationTestCase.assertEcho(true)}, {PetStoreFeatures.LEGACY_FEATURE_ONE, ECHO_MULE_CONTEXT, "4.2.2", "false", FeatureFlaggedApplicationTestCase.assertEcho(false)}, {PetStoreFeatures.LEGACY_FEATURE_ONE, ECHO_MULE_CONTEXT, "4.2.2", null, FeatureFlaggedApplicationTestCase.assertEcho(true)}, {PetStoreFeatures.LEGACY_FEATURE_ONE, ECHO_MULE_CONTEXT, "4.3.0", "true", FeatureFlaggedApplicationTestCase.assertEcho(true)}, {PetStoreFeatures.LEGACY_FEATURE_ONE, ECHO_MULE_CONTEXT, "4.3.0", "false", FeatureFlaggedApplicationTestCase.assertEcho(false)}, {PetStoreFeatures.LEGACY_FEATURE_ONE, ECHO_MULE_CONTEXT, "4.3.0", null, FeatureFlaggedApplicationTestCase.assertEcho(false)}, {PetStoreFeatures.LEGACY_FEATURE_ONE, ECHO_MULE_CONTEXT, null, "true", FeatureFlaggedApplicationTestCase.assertEcho(true)}, {PetStoreFeatures.LEGACY_FEATURE_ONE, ECHO_MULE_CONTEXT, null, "false", FeatureFlaggedApplicationTestCase.assertEcho(false)}, {PetStoreFeatures.LEGACY_FEATURE_ONE, ECHO_MULE_CONTEXT, null, null, FeatureFlaggedApplicationTestCase.assertEcho(false)}, {PetStoreFeatures.LEGACY_FEATURE_TWO, ECHO_FEATURE_CONTEXT, "4.2.2", "true", FeatureFlaggedApplicationTestCase.assertEcho(true)}, {PetStoreFeatures.LEGACY_FEATURE_TWO, ECHO_FEATURE_CONTEXT, "4.2.2", "false", FeatureFlaggedApplicationTestCase.assertEcho(false)}, {PetStoreFeatures.LEGACY_FEATURE_TWO, ECHO_FEATURE_CONTEXT, "4.2.2", null, FeatureFlaggedApplicationTestCase.assertEcho(true)}, {PetStoreFeatures.LEGACY_FEATURE_TWO, ECHO_FEATURE_CONTEXT, "4.3.0", "true", FeatureFlaggedApplicationTestCase.assertEcho(true)}, {PetStoreFeatures.LEGACY_FEATURE_TWO, ECHO_FEATURE_CONTEXT, "4.3.0", "false", FeatureFlaggedApplicationTestCase.assertEcho(false)}, {PetStoreFeatures.LEGACY_FEATURE_TWO, ECHO_FEATURE_CONTEXT, "4.3.0", null, FeatureFlaggedApplicationTestCase.assertEcho(false)}, {PetStoreFeatures.LEGACY_FEATURE_TWO, ECHO_FEATURE_CONTEXT, null, "true", FeatureFlaggedApplicationTestCase.assertEcho(true)}, {PetStoreFeatures.LEGACY_FEATURE_TWO, ECHO_FEATURE_CONTEXT, null, "false", FeatureFlaggedApplicationTestCase.assertEcho(false)}, {PetStoreFeatures.LEGACY_FEATURE_TWO, ECHO_FEATURE_CONTEXT, null, null, FeatureFlaggedApplicationTestCase.assertEcho(false)}, {MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, SPLITTER_EXCEPTION_FLOW, "4.2.2", "true", FeatureFlaggedApplicationTestCase.assertSplitterException(true)}, {MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, SPLITTER_EXCEPTION_FLOW, "4.2.2", "false", FeatureFlaggedApplicationTestCase.assertSplitterException(false)}, {MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, SPLITTER_EXCEPTION_FLOW, "4.2.2", null, FeatureFlaggedApplicationTestCase.assertSplitterException(false)}, {MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, SPLITTER_EXCEPTION_FLOW, "4.4.0", "true", FeatureFlaggedApplicationTestCase.assertSplitterException(true)}, {MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, SPLITTER_EXCEPTION_FLOW, "4.4.0", "false", FeatureFlaggedApplicationTestCase.assertSplitterException(false)}, {MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, SPLITTER_EXCEPTION_FLOW, "4.4.0", null, FeatureFlaggedApplicationTestCase.assertSplitterException(true)}, {MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, SPLITTER_EXCEPTION_FLOW, null, "true", FeatureFlaggedApplicationTestCase.assertSplitterException(true)}, {MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, SPLITTER_EXCEPTION_FLOW, null, "false", FeatureFlaggedApplicationTestCase.assertSplitterException(false)}, {MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION, SPLITTER_EXCEPTION_FLOW, null, null, FeatureFlaggedApplicationTestCase.assertSplitterException(false)}};
    }

    public FeatureFlaggedApplicationTestCase(org.mule.runtime.api.config.Feature testingFeature, String flowName, String minMuleVersion, String systemPropertyValue, Consumer<CoreEvent> assertions) {
        this.flowName = flowName;
        this.minMuleVersion = minMuleVersion;
        this.assertions = assertions;
        if (systemPropertyValue != null && testingFeature.getOverridingSystemPropertyName().isPresent()) {
            this.systemProperty = new SystemProperty((String)testingFeature.getOverridingSystemPropertyName().get(), systemPropertyValue);
        }
    }

    @BeforeClass
    public static void registerFeatureFlags() {
        PetStoreOperations.operationExecutionCounter.get();
    }

    protected String getConfigFile() {
        return "org/mule/config/feature-flagged-config.xml";
    }

    @Test
    public void getProperMessageDependingOnFeatureFlag() throws Exception {
        CoreEvent result = ((FlowRunner)this.flowRunner(this.flowName).withPayload((Object)PAYLOAD)).run();
        Assert.assertThat((Object)result.getMessage().getPayload(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.assertions.accept(result);
    }

    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration muleConfiguration = super.createMuleConfiguration();
        if (this.minMuleVersion != null) {
            muleConfiguration.setMinMuleVersion(new MuleVersion(this.minMuleVersion));
        } else {
            muleConfiguration.setMinMuleVersion(null);
        }
        return muleConfiguration;
    }

    private static Consumer<CoreEvent> assertEcho(boolean isLegacy) {
        return response -> {
            StringBuilder expected = new StringBuilder(PAYLOAD);
            if (isLegacy) {
                expected.append(" [old way]");
            }
            Assert.assertThat((Object)response.getMessage().getPayload(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)expected.toString()));
        };
    }

    private static Consumer<CoreEvent> assertSplitterException(boolean expected) {
        return response -> Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)expected));
    }
}

