/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.test.AbstractIntegrationTestCase;

@Issue(value="MULE-5737")
@Feature(value="Error Handling")
@Story(value="On Error Continue")
public class ExceptionPropagationMule5737TestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    static boolean parentCaught;
    static boolean childCaught;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/exception-propagation-mule-5737-config.xml";
    }

    @Before
    public void before() {
        parentCaught = false;
        childCaught = true;
    }

    @Test
    public void testRequestResponseEndpointExceptionPropagation() throws Exception {
        this.expectedError.expectErrorType("APP", "EXPECTED");
        this.runFlow("flow");
    }

    @Test
    public void testFlowWithChildFlowExceptionPropagation() throws Exception {
        this.runFlow("flowWithChildFlow");
        Assert.assertThat((Object)parentCaught, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)childCaught, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testFlowWithSubFlowExceptionPropagation() throws Exception {
        this.runFlow("flowWithSubFlow");
        Assert.assertThat((Object)parentCaught, (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testFlowWithChildServiceExceptionPropagation() throws Exception {
        this.runFlow("flowWithChildService");
        Assert.assertThat((Object)parentCaught, (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)childCaught, (Matcher)Matchers.is((Object)true));
    }

    public static Object senseParent(String payload) {
        parentCaught = true;
        return payload;
    }

    public static Object senseChild(String payload) {
        childCaught = true;
        return payload;
    }
}

