/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.firewall;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.util.NetworkUtils;
import org.mule.runtime.core.internal.config.factory.HostNameFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirewallTestCase
extends AbstractMuleTestCase {
    public static final String LOCALHOST = "localhost";
    public static final String LOCALADDR = "127.0.0.1";
    public static final int TEST_COUNT = 1;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Rule
    public DynamicPort port = new DynamicPort("port1");

    @Test
    public void testLoopback() throws Exception {
        this.consistentAddress(LOCALHOST, false);
    }

    @Test
    public void testLocalHost() throws Exception {
        InetAddress aLocalAddress = NetworkUtils.getLocalHost();
        this.logger.info("Java returns " + this.addressToString(aLocalAddress) + " as the 'local' address");
        Assert.assertNotSame((String)"No external address", (Object)LOCALADDR, (Object)aLocalAddress.getHostAddress());
        this.consistentAddress(aLocalAddress.getHostName(), false);
        Assert.assertEquals((String)"Inconsistent hostname", (Object)aLocalAddress.getHostName(), (Object)new HostNameFactory().create(null));
    }

    @Test
    public void testCanonicalHost() throws Exception {
        InetAddress aLocalAddress = NetworkUtils.getLocalHost();
        Assert.assertNotSame((String)"No extrernal name", (Object)LOCALHOST, (Object)aLocalAddress.getCanonicalHostName());
        this.consistentAddress(aLocalAddress.getCanonicalHostName(), true);
    }

    protected void consistentAddress(String name, boolean canonical) throws UnknownHostException {
        String address = InetAddress.getByName(name).getHostAddress();
        this.logger.debug("Testing relationship between " + name + " and " + address);
        Assert.assertEquals((String)("Name " + name + " is inconsistent"), (Object)name, (Object)this.name(InetAddress.getByName(name), canonical));
        Assert.assertEquals((String)("Address " + address + " is inconsistent"), (Object)address, (Object)InetAddress.getByName(address).getHostAddress());
        Assert.assertEquals((String)(name + " -> " + address + " is inconsistent"), (Object)address, (Object)InetAddress.getByName(name).getHostAddress());
        Assert.assertEquals((String)(name + " -> " + address + " -> " + name + " -> " + address + " is inconsistent"), (Object)address, (Object)InetAddress.getByName(this.name(InetAddress.getByName(InetAddress.getByName(name).getHostAddress()), canonical)).getHostAddress());
    }

    protected String name(InetAddress address, boolean canonical) {
        if (canonical) {
            return address.getCanonicalHostName();
        }
        return address.getHostName();
    }

    @Test
    public void testLocalhostTcp() throws Exception {
        for (int i = 0; i < 1; ++i) {
            this.doTestTcp(InetAddress.getByName(LOCALHOST), this.port.getNumber());
        }
    }

    @Test
    public void testHostnameTcp() throws Exception {
        for (int i = 0; i < 1; ++i) {
            this.doTestTcp(NetworkUtils.getLocalHost(), this.port.getNumber());
        }
    }

    @Test
    public void testLocalhostUdp() throws Exception {
        for (int i = 0; i < 1; ++i) {
            this.doTestUdp(InetAddress.getByName(LOCALHOST), this.port.getNumber());
        }
    }

    @Test
    public void testHostnameUdp() throws Exception {
        for (int i = 0; i < 1; ++i) {
            this.doTestUdp(NetworkUtils.getLocalHost(), this.port.getNumber());
        }
    }

    protected void doTestTcp(InetAddress address, int port) throws Exception {
        try {
            this.logger.debug("Testing TCP on " + this.addressToString(address, port));
            ServerSocket server = this.openTcpServer(address, port);
            Socket client = this.openTcpClient(address, port);
            Socket receiver = server.accept();
            client.getOutputStream().write(1);
            Assert.assertEquals((String)("Failed to send byte via " + this.addressToString(address, port)), (long)1L, (long)receiver.getInputStream().read());
            client.close();
            server.close();
        }
        catch (Exception e) {
            this.logger.error("Error while attempting TCP message on " + this.addressToString(address, port));
            throw e;
        }
    }

    protected void doTestUdp(InetAddress address, int port) throws Exception {
        try {
            this.logger.debug("Testing UDP on " + this.addressToString(address, port));
            DatagramSocket server = this.openUdpServer(address, port);
            DatagramSocket client = this.openUdpClient();
            client.send(new DatagramPacket(new byte[]{1}, 1, address, port));
            DatagramPacket packet = new DatagramPacket(new byte[1], 1);
            server.receive(packet);
            Assert.assertEquals((String)("Failed to send packet via " + this.addressToString(address, port)), (long)1L, (long)packet.getData()[0]);
            client.close();
            server.close();
        }
        catch (Exception e) {
            this.logger.error("Error while attempting UDP message on " + this.addressToString(address, port));
            throw e;
        }
    }

    protected Socket openTcpClient(InetAddress address, int port) throws IOException {
        try {
            return new Socket(address, port);
        }
        catch (IOException e) {
            this.logger.error("Could not open TCP client to " + this.addressToString(address, port));
            throw e;
        }
    }

    protected ServerSocket openTcpServer(InetAddress address, int port) throws IOException {
        try {
            return new ServerSocket(port, 1, address);
        }
        catch (IOException e) {
            this.logger.error("Could not open TCP server on " + this.addressToString(address, port));
            throw e;
        }
    }

    protected DatagramSocket openUdpServer(InetAddress address, int port) throws IOException {
        try {
            return new DatagramSocket(port, address);
        }
        catch (IOException e) {
            this.logger.error("Could not open UDP server on " + this.addressToString(address, port));
            throw e;
        }
    }

    protected DatagramSocket openUdpClient() throws IOException {
        try {
            return new DatagramSocket();
        }
        catch (IOException e) {
            this.logger.error("Could not open UDP client");
            throw e;
        }
    }

    protected String addressToString(InetAddress address, int port) {
        return this.addressToString(address) + ":" + port;
    }

    protected String addressToString(InetAddress address) {
        return address.getHostName() + "/" + address.getCanonicalHostName() + "/" + address.getHostAddress();
    }
}

