/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import com.google.common.collect.ImmutableList;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.text.RandomStringGenerator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsArrayWithSize;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.sdk.api.error.MuleErrors;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.processor.FlowAssert;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Scope")
@Story(value="Foreach")
public class ForeachTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public SystemProperty systemProperty = new SystemProperty("batch.size", "3");
    @Rule
    public ExpectedError expectedException = ExpectedError.none();
    private RandomStringGenerator randomStringGenerator;
    static String sampleXml = "<PurchaseOrder><Address><Name>Ellen Adams</Name></Address><Items><Item PartNumber=\"872-AA\"><Price>140</Price></Item><Item PartNumber=\"926-AA\"><Price>35</Price></Item></Items></PurchaseOrder>";

    @Before
    public void setUp() {
        this.randomStringGenerator = new RandomStringGenerator.Builder().withinRange(97, 122).build();
    }

    protected String getConfigFile() {
        return "org/mule/test/routing/foreach-test.xml";
    }

    @Test
    public void defaultConfiguration() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("julio");
        payload.add("sosa");
        Message result = ((FlowRunner)this.flowRunner("minimal-config").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection resultPayload = (Collection)result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertSame(payload, (Object)resultPayload);
        Message out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"julio"));
        out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"sosa"));
    }

    @Test
    public void defaultConfigurationPlusMP() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("syd");
        payload.add("barrett");
        Message result = ((FlowRunner)this.flowRunner("minimal-config-plus-mp").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection resultPayload = (Collection)result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertSame(payload, (Object)resultPayload);
        Message out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"syd"));
        out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"barrett"));
    }

    @Test
    public void defaultConfigurationExpression() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        names.add("residente");
        names.add("visitante");
        CoreEvent result = ((FlowRunner)((FlowRunner)this.flowRunner("minimal-config-expression").withPayload((Object)"message payload")).withVariable("names", names)).run();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)((List)((TypedValue)result.getVariables().get("names")).getValue()), (Matcher)IsCollectionWithSize.hasSize((int)names.size()));
        Message out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"residente"));
        out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"visitante"));
    }

    @Test
    public void partitionedConfiguration() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("gulp");
        payload.add("oktubre");
        payload.add("un baion");
        payload.add("bang bang");
        payload.add("la mosca");
        Message result = ((FlowRunner)this.flowRunner("partitioned-config").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection resultPayload = (Collection)result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsCollectionWithSize.hasSize((int)5));
        Assert.assertSame(payload, (Object)resultPayload);
        Message out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection outPayload = (Collection)out.getPayload().getValue();
        Assert.assertThat((Object)outPayload, (Matcher)IsCollectionWithSize.hasSize((int)3));
        out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        outPayload = (Collection)out.getPayload().getValue();
        Assert.assertThat((Object)outPayload, (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void rootMessageConfiguration() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("pyotr");
        payload.add("ilych");
        Message result = ((FlowRunner)this.flowRunner("parent-message-config").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection resultPayload = (Collection)result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertSame(payload, (Object)resultPayload);
    }

    @Test
    public void mapPayload() throws Exception {
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("name", "david");
        payload.put("surname", "bowie");
        Message result = ((FlowRunner)this.flowRunner("map-config").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Map.class));
        Map resultPayload = (Map)result.getPayload().getValue();
        Assert.assertThat(resultPayload.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)payload.size()));
        Assert.assertSame(payload, (Object)resultPayload);
    }

    @Test
    public void splitStringWithHardcodedValue() throws Exception {
        this.flowRunner("splitStringHardcodedValue").run();
        this.assertSplitedString();
    }

    @Test
    public void splitStringWithStringFromPayload() throws Exception {
        ((FlowRunner)this.flowRunner("splitStringHardcodedValue").withPayload((Object)"a-b-c")).run();
        this.assertSplitedString();
    }

    @Description(value="Splits a JSON into an array of simple values and iterate over those values")
    @Test
    public void splitJson() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("splitJson").withPayload((Object)"{\"name\":\"Pepe\", \"lastname\":\"Le Pew\"}")).withMediaType(MediaType.APPLICATION_JSON)).run();
        this.assertQueueValueIs("splitJsonOutQueue", "Pepe");
        this.assertQueueValueIs("splitJsonOutQueue", "Le Pew");
    }

    @Description(value="Splits a JSON array that is inside an string in the payload without using any expression")
    @Test
    public void splitJsonArrayWithoutExpression() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("splitJsonArray").withPayload((Object)"[ \"1\", \"2\" ]")).withMediaType(MediaType.APPLICATION_JSON)).run();
        this.assertQueueValueIs("splitJsonArrayOutQueue", "1");
        this.assertQueueValueIs("splitJsonArrayOutQueue", "2");
    }

    @Description(value="Splits a JSON into other JSON objects and executed expressions over each object")
    @Test
    public void splitJsonComplexValue() throws Exception {
        String jsonUsers = "{ \"users\": [{ \"name\": \"Pepe\", \"lastname\": \"Le Pew\" },{ \"name\": \"Chuck\", \"lastname\": \"Jones\" },{ \"name\": \"Dick\", \"lastname\": \"Dastardly\" },{ \"name\": \"William\", \"lastname\": \"Hanna\" }] }";
        ((FlowRunner)((FlowRunner)this.flowRunner("splitJsonComplexValue").withVariable("content", (Object)jsonUsers, DataType.JSON_STRING)).withMediaType(MediaType.APPLICATION_JSON)).run();
        this.assertQueueValueIs("splitJsonComplexValueOutQueue", "Pepe Le Pew");
        this.assertQueueValueIs("splitJsonComplexValueOutQueue", "Chuck Jones");
        this.assertQueueValueIs("splitJsonComplexValueOutQueue", "Dick Dastardly");
        this.assertQueueValueIs("splitJsonComplexValueOutQueue", "William Hanna");
    }

    @Description(value="Splits an array of string generated from an expression executed over an XML payload")
    @Test
    public void splitXml() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("splitXml").withPayload((Object)"<person><name>Pepe</name><lastname>Le Pew</lastname></person>")).withMediaType(MediaType.APPLICATION_XML)).run();
        this.assertQueueValueIs("splitXmlOutQueue", "Pepe");
        this.assertQueueValueIs("splitXmlOutQueue", "Le Pew");
    }

    @Description(value="Splits an XML where root contains a collection of child elements and verifies that expressions over each child element inside the foreach works")
    @Test
    public void spliXmlComplexValue() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("splitXmlComplexValue").withPayload((Object)sampleXml)).withMediaType(MediaType.APPLICATION_XML)).run();
        this.assertQueueValueIs("splitXmlComplexValueOutQueue", "872-AA 140");
        this.assertQueueValueIs("splitXmlComplexValueOutQueue", "926-AA 35");
    }

    @Description(value="Splits a collection of Messages and verifies that the Message payload and attribute are set as payload and attributes of the routed message")
    @Test
    public void splitCollectionOfMessages() throws Exception {
        ImmutableList payload = ImmutableList.builder().add((Object)Message.builder().value((Object)"1").attributesValue((Object)"one").build()).add((Object)Message.builder().value((Object)"2").attributesValue((Object)"two").build()).build();
        ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("splitPayload").withVariable("useExpression", (Object)false)).withPayload((Object)payload)).withMediaType(MediaType.APPLICATION_JAVA)).run();
        this.assertQueueValueIs("splitPayloadOutQueue", "1");
        this.assertQueueValueIs("splitPayloadOutQueue", "2");
    }

    @Description(value="Splits a collection of Messages with JSON payloads represented as string and verifies that inside the foreach, expressions associated with the json content work fine")
    @Test
    public void splitCollectionOfJsonMessagesAndEachValueHasRightContentType() throws Exception {
        String firstPaylaod = "{ \"name\": \"Pepe\", \"lastname\": \"Le Pew\" }";
        String secondPayload = "{ \"name\": \"Chuck\", \"lastname\": \"Jones\" }";
        ImmutableList payload = ImmutableList.builder().add((Object)Message.builder().value((Object)firstPaylaod).mediaType(MediaType.APPLICATION_JSON).build()).add((Object)Message.builder().value((Object)secondPayload).mediaType(MediaType.APPLICATION_JSON).build()).build();
        ((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("splitPayload").withVariable("useExpression", (Object)true)).withPayload((Object)payload)).withMediaType(MediaType.APPLICATION_JAVA)).run();
        this.assertQueueValueIs("splitPayloadOutQueue", "Pepe");
        this.assertQueueValueIs("splitPayloadOutQueue", "Chuck");
    }

    private void assertQueueValueIs(String queueName, Object queueValue) {
        Message receivedMessage = this.queueManager.read(queueName, 1000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)receivedMessage.getPayload().getValue(), (Matcher)Is.is((Object)queueValue));
    }

    private void assertSplitedString() {
        this.assertQueueValueIs("splitStringOutQueue", "a");
        this.assertQueueValueIs("splitStringOutQueue", "b");
        this.assertQueueValueIs("splitStringOutQueue", "c");
    }

    private void xml(Object payload) throws Exception {
        CoreEvent result = ((FlowRunner)((FlowRunner)this.flowRunner("process-order-update").withPayload(payload)).withMediaType(MediaType.APPLICATION_XML)).run();
        int total = (Integer)((TypedValue)result.getVariables().get("total")).getValue();
        Assert.assertThat((Object)total, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @Ignore(value="MULE-9285")
    @Issue(value="MULE-9285")
    @Test
    public void xmlUpdateByteArray() throws Exception {
        this.xml(sampleXml.getBytes());
    }

    @Test
    @Ignore(value="MULE-19198")
    public void jsonUpdate() throws Exception {
        ArrayList<Map<String, String>> items = new ArrayList<Map<String, String>>();
        items.add(Collections.singletonMap("key1", "value1"));
        items.add(Collections.singletonMap("key2", "value2"));
        HashMap<String, Object> order = new HashMap<String, Object>();
        order.put("name", "Ellen");
        order.put("email", "ellen.mail.com");
        order.put("items", items);
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConcurrentModificationException.class));
        ((FlowRunner)this.flowRunner("process-json-update").withPayload(Collections.singletonMap("order", order))).run();
    }

    @Test
    public void arrayPayload() throws Exception {
        String[] payload = new String[]{"uno", "dos", "tres"};
        Message result = ((FlowRunner)this.flowRunner("array-expression-config").withPayload((Object)payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String[].class));
        String[] resultPayload = (String[])result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsArrayWithSize.arrayWithSize((int)payload.length));
        Assert.assertSame((Object)payload, (Object)resultPayload);
    }

    @Test
    public void variableScope() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("pedro");
        payload.add("rodolfo");
        payload.add("roque");
        ((FlowRunner)this.flowRunner("counter-scope").withPayload(payload)).run();
    }

    @Test
    public void twoOneAfterAnother() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("rosa");
        payload.add("maria");
        payload.add("florencia");
        Message result = ((FlowRunner)this.flowRunner("counter-two-foreach-independence").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection resultPayload = (Collection)result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertSame(payload, (Object)resultPayload);
    }

    @Test
    public void nestedConfig() throws Exception {
        List<List<String>> payload = this.createNestedPayload();
        Message result = ((FlowRunner)this.flowRunner("nested-foreach").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection resultPayload = (Collection)result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertSame(payload, (Object)resultPayload);
        for (int i = 0; i < payload.size(); ++i) {
            for (int j = 0; j < payload.get(i).size(); ++j) {
                Message out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
                Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
                Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)payload.get(i).get(j)));
            }
        }
    }

    @Test
    public void nestedCounters() throws Exception {
        List<List<String>> payload = this.createNestedPayload();
        Message result = ((FlowRunner)this.flowRunner("nested-foreach-counters").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection resultPayload = (Collection)result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertSame(payload, (Object)resultPayload);
        for (int i = 0; i < payload.size(); ++i) {
            for (int j = 0; j < payload.get(i).size(); ++j) {
                this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
            }
            this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        }
    }

    private List<List<String>> createNestedPayload() {
        ArrayList<List<String>> payload = new ArrayList<List<String>>();
        ArrayList<String> elem1 = new ArrayList<String>();
        ArrayList<String> elem2 = new ArrayList<String>();
        ArrayList<String> elem3 = new ArrayList<String>();
        elem1.add("a1");
        elem1.add("a2");
        elem1.add("a3");
        elem2.add("b1");
        elem2.add("b2");
        elem3.add("c1");
        payload.add(elem1);
        payload.add(elem2);
        payload.add(elem3);
        return payload;
    }

    @Test
    public void propertiesRestored() throws Exception {
        String[] payload = new String[]{"uno", "dos", "tres"};
        Message result = ((FlowRunner)this.flowRunner("foreach-properties-restored").withPayload((Object)payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String[].class));
        String[] resultPayload = (String[])result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsArrayWithSize.arrayWithSize((int)payload.length));
        Assert.assertSame((Object)payload, (Object)resultPayload);
    }

    private void assertIterable() {
        Message out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        String outPayload = (String)out.getPayload().getValue();
        Assert.assertThat((Object)outPayload, (Matcher)CoreMatchers.is((Object)"foo"));
        out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        outPayload = (String)out.getPayload().getValue();
        Assert.assertThat((Object)outPayload, (Matcher)CoreMatchers.is((Object)"bar"));
    }

    @Test
    public void expressionIterable() throws Exception {
        Iterable iterable = (Iterable)Mockito.mock(Iterable.class);
        Mockito.when(iterable.iterator()).thenReturn(Arrays.asList("foo", "bar").iterator());
        ((FlowRunner)this.flowRunner("expression-iterable").withVariable("iterable", (Object)iterable)).run();
        this.assertIterable();
    }

    @Test
    public void mvelError() throws Exception {
        MuleException me = (MuleException)this.flowRunner("errorExpression").runExpectingException();
        Assert.assertThat((Object)((String)me.getInfo().get("Element")), (Matcher)CoreMatchers.startsWith((String)"errorExpression/processors/0 @"));
    }

    @Test
    public void foreachWithAsync() throws Exception {
        int size = 20;
        ArrayList<String> list = new ArrayList<String>(20);
        for (int i = 0; i < 20; ++i) {
            list.add(this.randomStringGenerator.generate(10));
        }
        CountDownLatch latch = new CountDownLatch(21);
        ((FlowRunner)((FlowRunner)this.flowRunner("foreachWithAsync").withPayload(list)).withVariable("latch", (Object)latch)).run();
        Assert.assertThat((String)latch.toString(), (Object)latch.await(10L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
    }

    public static CountDownLatch coundDownLatch(CountDownLatch latch) {
        latch.countDown();
        return latch;
    }

    @Test
    public void errorsWithinArePropagated() throws Exception {
        Message message = ((FlowRunner)this.flowRunner("error-handler").withPayload((Object)new String[]{"test"})).run().getMessage();
        Assert.assertThat((Object)message, (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)"handled")));
    }

    @Test
    public void nonBlocking() throws Exception {
        ((FlowRunner)this.flowRunner("nonBlocking").withPayload(Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9"))).run();
        FlowAssert.verify((String)"nonBlocking");
    }

    @Test
    public void errorAfterThreadChange() throws Exception {
        this.expectedException.expectErrorType("MULE", MuleErrors.CONNECTIVITY.name());
        ((FlowRunner)this.flowRunner("errorAfterThreadChange").withPayload(Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9"))).run();
    }

    @Test
    @Description(value="Validates that for each can be used correctly within an error handler")
    public void foreachInErrorHandler() throws Exception {
        CoreEvent event = this.flowRunner("foreachInErrorHandler").run();
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"apple"));
    }

    @Test
    @Issue(value="MULE-18524")
    public void forEachWithTry() throws Exception {
        ((FlowRunner)this.flowRunner("forEachWithTry").withPayload((Object)ImmutableList.of((Object)"one", (Object)"two", (Object)"three"))).run();
    }

    @Test
    @Issue(value="MULE-18462")
    public void forEachEmptyCollection() throws Exception {
        this.flowRunner("emptyForEach").run();
    }

    @Test
    @Issue(value="W-15617764")
    public void sequenceInfoAccessible() throws Exception {
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("bruce");
        payload.add("dickinson");
        Message result = ((FlowRunner)this.flowRunner("sequence-info-accessible").withPayload(payload)).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(Collection.class));
        Collection resultPayload = (Collection)result.getPayload().getValue();
        Assert.assertThat((Object)resultPayload, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertSame(payload, (Object)resultPayload);
        Message out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"0"));
        out = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.instanceOf(String.class));
        Assert.assertThat((Object)out.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"1"));
    }

    protected boolean isGracefulShutdown() {
        return true;
    }
}

