/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.sync;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.processor.FlowAssert;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

public class HttpJmsBridgeTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public DynamicPort httpPort = new DynamicPort("port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/usecases/sync/http-jms-bridge-flow.xml";
    }

    @Test
    public void testBridge() throws Exception {
        String payload = "payload";
        MultiMap headersMap = new MultiMap();
        String customHeader = "X-Custom-Header";
        headersMap.put((Object)"X-Custom-Header", (Object)"value");
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/in", this.httpPort.getNumber())).entity((HttpEntity)new ByteArrayHttpEntity(payload.getBytes()))).headers(headersMap)).method(HttpConstants.Method.POST).build();
        this.httpClient.send(request, 5000, false, null);
        Message msg = this.queueManager.read("out", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertNotNull((Object)msg);
        Assert.assertThat((Object)this.getPayloadAsString(msg), (Matcher)CoreMatchers.is((Object)payload));
        FlowAssert.verify((String)"bridge");
    }
}

