/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.message.Message;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.routing.ThreadCaptor;

@Feature(value="Routers")
@Story(value="Choice")
public class ChoiceRouterTestCase
extends AbstractIntegrationTestCase {
    private static final int LOAD = Runtime.getRuntime().availableProcessors() * 10;

    protected String getConfigFile() {
        return "routers/choice-router-config.xml";
    }

    @Test
    public void noDefaultAndNoMatchingRoute() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("flow").withPayload((Object)"test")).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)Is.is((Object)"testafterRouteMpCounter"));
    }

    @Test
    public void defaultAndNoMatchingRoute() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("otherwise").withPayload((Object)"test")).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)Is.is((Object)"testotherwiseCounterafterCounter"));
    }

    @Test
    public void multipleMatchingRoutes() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("multiple").withPayload((Object)"test")).run().getMessage();
        Assert.assertThat((Object)result.getPayload().getValue(), (Matcher)Is.is((Object)"testfirstafter"));
    }

    @Test
    public void errorsWithinRouteArePropagated() throws Exception {
        this.assertMultipleErrors("error-handler", "handled");
    }

    @Test
    public void errorsWithinRouteExpressionArePropagated() throws Exception {
        this.assertMultipleErrors("expression", "handled");
    }

    @Test
    public void errorsWithinTryRouteArePropagated() throws Exception {
        this.assertMultipleErrors("try-error-handler", "handled after try");
    }

    @Test
    public void errorsWithinTryRouteExpressionArePropagated() throws Exception {
        this.assertMultipleErrors("try-expression", "handled after try");
    }

    private void assertMultipleErrors(String expression, String expected) throws Exception {
        for (int i = 0; i < LOAD; ++i) {
            Message message = ((FlowRunner)this.flowRunner(expression).withPayload((Object)"test")).run().getMessage();
            Assert.assertThat((Object)message, (Matcher)MessageMatchers.hasPayload((Matcher)CoreMatchers.equalTo((Object)expected)));
        }
    }

    @Test
    public void txWithNonBlockingRoute() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("txNonBlocking").withPayload((Object)"nonBlocking")).run().getMessage();
        Assert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void txWithCpuIntensiveRoute() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("txCpuIntensive").withPayload((Object)"cpuIntensive")).run().getMessage();
        Assert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void txWithBlockingRoute() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("txBlocking").withPayload((Object)"blocking")).run().getMessage();
        Assert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void txWithOtherwise() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("txOtherwise").withPayload((Object)"ooo")).run().getMessage();
        Assert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void txWithNoOtherwise() throws Exception {
        Message result = ((FlowRunner)this.flowRunner("txNoOtherwise").withPayload((Object)"ooo")).run().getMessage();
        Assert.assertThat(ThreadCaptor.getCapturedThreads(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    @Issue(value="MULE-18803")
    @Description(value="Verify that using a non-blocking processor in the default route of a choice is not flaky.This was flaky because of a race condition between the processing of the defaut route and the completion of that flux for that route when the choice was iniside a Mono component.")
    public void nonBlockingProcessorInDefaultRoute() throws Exception {
        for (int i = 0; i < 5000; ++i) {
            FlowRunner flowRunner = (FlowRunner)this.flowRunner("nonBlockingProcessorInDefaultRoute").withPayload((Object)"ooo");
            flowRunner.run();
        }
    }
}

