/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.tls;

import io.qameta.allure.Issue;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.DomainFunctionalTestCase;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;

@Ignore(value="MULE-10633")
@Issue(value="MULE-10633")
public class TlsSharedContextTestCase
extends DomainFunctionalTestCase {
    private static final String DATA = "data";
    private static final String FIRST_APP = "firstApp";
    private static final String SECOND_APP = "secondApp";
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public DynamicPort port3 = new DynamicPort("port3");
    private Registry domainRegistry;

    protected String getDomainConfig() {
        return "domain/tls/tls-domain-config.xml";
    }

    protected Map<String, Object> getDomainStartUpRegistryObjects() {
        return Collections.singletonMap("RegistryHolder", new RegistryHolder());
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig(FIRST_APP, new String[]{"domain/tls/tls-first-app-config.xml"}), new DomainFunctionalTestCase.ApplicationConfig(SECOND_APP, new String[]{"domain/tls/tls-second-app-config.xml"})};
    }

    @Test
    public void sharedRequesterUsingSharedTlsContextToLocalListener() throws Exception {
        this.testFlowForApp("helloWorldClientFlow", FIRST_APP, "hello world");
    }

    @Test
    public void localRequesterToSharedListenerUsingSharedTlsContext() throws Exception {
        this.testFlowForApp("helloMuleClientFlow", SECOND_APP, "hello mule");
    }

    @Test
    public void muleClientUsingSharedTlsContextToListenerUsingSharedTlsContext() throws Exception {
        TlsContextFactory tlsContextFactory = (TlsContextFactory)this.domainRegistry.lookupByName("sharedTlsContext2").get();
        TestHttpClient httpClient = new TestHttpClient.Builder().tlsContextFactory(tlsContextFactory).build();
        httpClient.start();
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("https://localhost:%s/helloAll", this.port3.getValue())).method(HttpConstants.Method.GET).entity((HttpEntity)new ByteArrayHttpEntity(DATA.getBytes()))).build();
        HttpResponse response = httpClient.send(request, 60, false, null);
        httpClient.stop();
        Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)"hello all"));
    }

    private void testFlowForApp(String flowName, String appName, String expected) throws Exception {
        CoreEvent response = ((FlowRunner)new FlowRunner(this.getInfrastructureForApp(appName).getRegistry(), flowName).withPayload((Object)DATA)).run();
        Assert.assertThat((Object)((PrivilegedEvent)response).getMessageAsString(this.getMuleContextForApp(appName)), (Matcher)Matchers.is((Object)expected));
    }

    public class RegistryHolder {
        @Inject
        public void setRegistry(Registry registry) {
            TlsSharedContextTestCase.this.domainRegistry = registry;
        }
    }
}

