/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.http.api.request.validator.ResponseValidatorException;
import org.mule.extension.test.extension.reconnection.ReconnectableConnectionProvider;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.http.api.HttpService;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.heisenberg.extension.HeisenbergConnectionProvider;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.model.KillParameters;

@Feature(value="Interception API")
@Story(value="Component Interception Story")
public class ProcessorInterceptorFactoryTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @Rule
    public DynamicPort wireMockPort = new DynamicPort("wireMockPort");
    @Rule
    public WireMockRule wireMock = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().bindAddress("127.0.0.1").port(this.wireMockPort.getNumber()));

    @Before
    public void setUp() {
        this.wireMock.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/200")).willReturn(WireMock.aResponse().withStatus(200)));
        this.wireMock.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/404")).willReturn(WireMock.aResponse().withStatus(404)));
        this.wireMock.stubFor(WireMock.get((UrlMatchingStrategy)WireMock.urlMatching((String)"/418")).willReturn(WireMock.aResponse().withStatus(418)));
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/processor-interceptor-factory.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_AfterWithCallbackInterceptorFactory", new AfterWithCallbackInterceptorFactory());
        objects.put("_HasInjectedAttributesInterceptorFactory", new HasInjectedAttributesInterceptorFactory(false));
        objects.put("_EvaluatesExpressionInterceptorFactory", new EvaluatesExpressionInterceptorFactory());
        objects.put("_ErrorMappingRequiredInterceptorFactory", new ErrorMappingRequiredInterceptorFactory());
        objects.put("_muleProcessorInterceptorFactoryOrder", () -> Arrays.asList(AfterWithCallbackInterceptorFactory.class.getName(), HasInjectedAttributesInterceptorFactory.class.getName(), EvaluatesExpressionInterceptorFactory.class.getName(), ErrorMappingRequiredInterceptorFactory.class.getName()));
        return objects;
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        super.doSetUpBeforeMuleContextCreation();
        ReconnectableConnectionProvider.fail = true;
    }

    protected void doSetUp() throws Exception {
    }

    @After
    public void after() {
        ReconnectableConnectionProvider.fail = false;
        HeisenbergConnectionProvider.getActiveConnections().clear();
        HasInjectedAttributesInterceptor.interceptionParameters.clear();
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {};
    }

    @Test
    public void operationParameters() throws Exception {
        ((FlowRunner)((FlowRunner)this.flowRunner("killFromPayload").withPayload((Object)"T-1000")).withVariable("goodbye", (Object)"Hasta la vista, baby")).run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        InterceptionParameters killInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "victim", "goodbyeMessage"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("victim").resolveValue(), (Matcher)Matchers.is((Object)"T-1000"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("goodbyeMessage").resolveValue(), (Matcher)Matchers.is((Object)"Hasta la vista, baby"));
    }

    @Test
    public void resolvedConfigOperationParameters() throws Exception {
        this.flowRunner("die").run();
        Assert.assertThat((Object)HasInjectedAttributesInterceptor.interceptionParameters.size(), (Matcher)Matchers.is((Object)1));
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        InterceptionParameters dieInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(dieInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"config-ref", "config"}));
        Object config = dieInterceptionParameter.getParameters().get("config").resolveValue();
        Assert.assertThat((Object)config, (Matcher)Matchers.instanceOf(HeisenbergExtension.class));
        Assert.assertThat((Object)((HeisenbergExtension)config).getConfigName(), (Matcher)Matchers.is((Object)"heisenberg"));
        Object configRef = dieInterceptionParameter.getParameters().get("config-ref").resolveValue();
        Assert.assertThat((Object)configRef, (Matcher)Matchers.is((Object)"heisenberg"));
    }

    @Test
    public void operationThatUsesExtensionsClientInternally() throws Exception {
        Assert.assertThat((Object)this.flowRunner("executeKillWithClient").run().getMessage().getPayload().getValue().toString(), (Matcher)Matchers.is((Object)"Now he sleeps with the fishes."));
        Assert.assertThat((Object)HasInjectedAttributesInterceptor.interceptionParameters.size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void resolvedComplexParametersOperationParameters() throws Exception {
        ((FlowRunner)this.flowRunner("killWithCustomMessage").withVariable("goodbye", (Object)"Hasta la vista, baby")).run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        InterceptionParameters killInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "victim", "goodbyeMessage", "killParameters"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("victim").resolveValue(), (Matcher)Matchers.is((Object)"T-1000"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("goodbyeMessage").resolveValue(), (Matcher)Matchers.is((Object)"Hasta la vista, baby"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("killParameters").resolveValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(KillParameters.class)));
    }

    @Test
    @Description(value="Verify that even if an operation has parameters with invalid expressions, before is called for the interceptor.")
    public void executeOperationWithInvalidExpression() throws Exception {
        this.flowRunner("executeOperationWithInvalidExpression").runExpectingException();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
        InterceptionParameters killInterceptionParameter = interceptionParameters.get(0);
        Assert.assertThat(killInterceptionParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"targetValue", "victim", "goodbyeMessage"}));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().get("victim").resolveValue(), (Matcher)Matchers.is((Object)"T-1000"));
        Assert.assertThat((Object)killInterceptionParameter.getParameters().containsKey("goodbyeMessage"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Description(value="The errorType set by an operation is preserved if an interceptor is applied")
    public void failingOperationErrorTypePreserved() throws Exception {
        AtomicBoolean afterCallbackCalled = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            Assert.assertThat((Object)((Throwable)thrown.get()), (Matcher)Matchers.instanceOf(ConnectionException.class));
            Assert.assertThat((Object)((Throwable)thrown.get()).getCause(), (Matcher)Matchers.instanceOf(HeisenbergException.class));
            Assert.assertThat((Object)((Throwable)thrown.get()).getMessage(), (Matcher)Matchers.endsWith((String)"You are not allowed to speak with gus."));
            Assert.assertThat((Object)((Error)event.getError().get()).getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"HEISENBERG", (String)"CONNECTIVITY"));
            afterCallbackCalled.set(true);
        };
        this.expectedError.expectErrorType("HEISENBERG", "CONNECTIVITY");
        try {
            this.flowRunner("callGusFring").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalled.get(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    @Issue(value="MULE-19236")
    @Description(value="The errorType set by an operation and then mapped is preserved if an interceptor is applied")
    public void failingOperationMappedErrorTypePreserved() throws Exception {
        AtomicBoolean afterCallbackCalled = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            Assert.assertThat((Object)((Error)event.getError().get()).getErrorType(), (Matcher)ErrorTypeMatcher.errorType((String)"APP", (String)"MAPPED_CONNECTIVITY"));
            afterCallbackCalled.set(true);
        };
        this.expectedError.expectErrorType("APP", "MAPPED_CONNECTIVITY");
        try {
            this.flowRunner("operationErrorWithMappings").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalled.get(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    @Issue(value="MULE-19866")
    @Description(value="The errorType set by an operation and then mapped, is mapped again if an interceptor that requires error mapping is applied")
    public void failingOperationMappedErrorTypeRemapped() throws Exception {
        ErrorMappingRequiredInterceptor.callback = location -> true;
        this.expectedError.expectErrorType("APP", "ANYTHING_ELSE");
        this.flowRunner("operationErrorWithMappings").run();
    }

    @Test
    public void expressionsInInterception() throws Exception {
        Assert.assertThat((Object)((TypedValue)this.flowRunner("expressionsInInterception").run().getVariables().get("addedVar")).getValue(), (Matcher)Matchers.is((Object)"value2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Errors in sub-flows are handled correctly")
    public void failingSubFlow() throws Exception {
        List<InterceptionParameters> interceptionParameters;
        this.expectedError.expectErrorType("APP", "EXPECTED");
        try {
            this.flowRunner("flowWithFailingSubFlowRef").run();
            interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        }
        catch (Throwable throwable) {
            List<InterceptionParameters> interceptionParameters2 = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters2, (Matcher)Matchers.hasSize((int)3));
            InterceptionParameters flowRefParameter = interceptionParameters2.get(0);
            Assert.assertThat(flowRefParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"name", "targetValue"}));
            Assert.assertThat((Object)flowRefParameter.getParameters().get("name").resolveValue(), (Matcher)Matchers.is((Object)"failing-sub-flow"));
            InterceptionParameters failParameter = interceptionParameters2.get(1);
            Assert.assertThat(failParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"type"}));
            Assert.assertThat((Object)failParameter.getParameters().get("type").resolveValue(), (Matcher)Matchers.is((Object)"APP:EXPECTED"));
            throw throwable;
        }
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)3));
        InterceptionParameters flowRefParameter = interceptionParameters.get(0);
        Assert.assertThat(flowRefParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"name", "targetValue"}));
        Assert.assertThat((Object)flowRefParameter.getParameters().get("name").resolveValue(), (Matcher)Matchers.is((Object)"failing-sub-flow"));
        InterceptionParameters failParameter = interceptionParameters.get(1);
        Assert.assertThat(failParameter.getParameters().keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"type"}));
        Assert.assertThat((Object)failParameter.getParameters().get("type").resolveValue(), (Matcher)Matchers.is((Object)"APP:EXPECTED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in error handlers are intercepted correctly")
    public void errorHandler() throws Exception {
        this.expectedError.expectErrorType("APP", "EXPECTED");
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat((Object)((Throwable)thrown.get()), (Matcher)Matchers.instanceOf(DefaultMuleException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowFailingWithErrorHandler").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"flowFailingWithErrorHandler/errorHandler/0/processors/0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly")
    public void globalErrorHandler() throws Exception {
        this.expectedError.expectErrorType("APP", "EXPECTED");
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat((Object)((Throwable)thrown.get()), (Matcher)Matchers.instanceOf(DefaultMuleException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowFailing").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"globalErrorHandler/0/processors/0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly when raise-error is used")
    public void globalErrorHandlerRaise() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(DefaultMuleException.class));
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat((Object)((Throwable)thrown.get()), (Matcher)Matchers.instanceOf(DefaultMuleException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowRaise").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"globalErrorHandler/0/processors/0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for errors in operations")
    public void globalErrorHandlerOperation() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(HeisenbergException.class));
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat((Object)((Throwable)thrown.get()), (Matcher)Matchers.instanceOf(HeisenbergException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowFailingOperation").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"globalErrorHandler/0/processors/0"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly for an unknown status code errors in http request")
    public void globalErrorHandlerUnknownStatusCodeHttpRequest() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(ResponseValidatorException.class));
        AtomicBoolean afterCallbackCalledForFailingMP = new AtomicBoolean(false);
        AtomicBoolean afterCallbackCalledForErrorHandlingMp = new AtomicBoolean(false);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            if (!afterCallbackCalledForFailingMP.getAndSet(true)) {
                Assert.assertThat((Object)((Throwable)thrown.get()), (Matcher)Matchers.instanceOf(ResponseValidatorException.class));
            } else {
                afterCallbackCalledForErrorHandlingMp.set(true);
            }
        };
        try {
            this.flowRunner("flowUnknownStatusCodeHttpRequest").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalledForFailingMP.get(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)afterCallbackCalledForErrorHandlingMp.get(), (Matcher)Matchers.is((Object)true));
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)2));
            InterceptionParameters mpInGlobalErrorHandler = interceptionParameters.get(1);
            Assert.assertThat((Object)mpInGlobalErrorHandler.getLocation().getLocation(), (Matcher)Matchers.is((Object)"globalErrorHandler/0/processors/0"));
        }
    }

    @Test
    public void loggerWithTemplate() throws Exception {
        ((FlowRunner)this.flowRunner("loggerWithTemplate").withVariable("v1", (Object)"value")).run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        InterceptionParameters param = interceptionParameters.get(0);
        Assert.assertThat((Object)((ProcessorParameterValue)param.parameters.get("message")).resolveValue(), (Matcher)Matchers.is((Object)"Logging value"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Description(value="Processors in global error handlers are intercepted correctly when error is in referenced flow")
    public void globalErrorHandlerWithFlowRef() throws Exception {
        this.expectedError.expectErrorType("APP", "EXPECTED");
        CountDownLatch allAftersWereCalled = new CountDownLatch(4);
        AtomicInteger afters = new AtomicInteger(0);
        AfterWithCallbackInterceptor.callback = (event, thrown) -> {
            afters.incrementAndGet();
            allAftersWereCalled.countDown();
        };
        try {
            this.flowRunner("flowWithFailingFlowRef").run();
        }
        finally {
            allAftersWereCalled.await();
            List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
            Assert.assertThat((String)interceptionParameters.stream().map(ip -> ip.getLocation().getLocation()).collect(Collectors.toList()).toString(), interceptionParameters, (Matcher)Matchers.hasSize((int)4));
            Assert.assertThat((Object)afters.get(), (Matcher)Matchers.is((Object)4));
        }
    }

    @Test
    @Description(value="Processors inside an SDK scope with implicit configs are initialised correctly")
    public void implicitConfigInNestedScope() throws Exception {
        Assert.assertThat((Object)this.flowRunner("implicitConfigInNestedScope").run(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    @Description(value="Test the parameter interception using Scripting, which uses the legacy operation executor")
    public void interceptParametersUsingLegacyOperationExecutorFactory() throws Exception {
        this.flowRunner("interceptingScriptingParameters").run();
        List<InterceptionParameters> interceptionParameters = HasInjectedAttributesInterceptor.interceptionParameters;
        Assert.assertThat(interceptionParameters, (Matcher)Matchers.hasSize((int)1));
        Map<String, ProcessorParameterValue> scriptingParameters = interceptionParameters.get(0).getParameters();
        Assert.assertThat(scriptingParameters.keySet(), (Matcher)Matchers.hasSize((int)5));
        Assert.assertThat(scriptingParameters.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"engine", "doc:name", "target", "code", "targetValue"}));
        Assert.assertThat((Object)scriptingParameters.get("doc:name").resolveValue(), (Matcher)Matchers.is((Object)"Execute 5"));
    }

    @Test
    @Issue(value="MULE-19245")
    public void operationWithDeferredStreamParam() throws Exception {
        CoreEvent result = this.flowRunner("operationWithDeferredStreamParam").run();
        Assert.assertThat((Object)result.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"Knocked on Jim Malone"));
    }

    @Test
    @Issue(value="MULE-19315")
    @Description(value="Reconnection configuration is honored when resolving params through interception API")
    public void reconnectionWorksWithInterceptors() throws Exception {
        ReconnectableConnectionProvider.fail = true;
        this.flowRunner("reconnectionWorksWithInterceptors").run();
        Assert.assertThat((Object)ReconnectableConnectionProvider.fail, (Matcher)Matchers.is((Object)false));
    }

    @Test
    @Issue(value="MULE-19315")
    @Description(value="Connectivity errors are propagated consistenly when interception API is present.")
    public void reconnectionFailureWorksWithInterceptors() throws Exception {
        ReconnectableConnectionProvider.fail = true;
        this.flowRunner("reconnectionFailureWorksWithInterceptors").runExpectingException(ErrorTypeMatcher.errorType((String)"RECONNECTION", (String)"CONNECTIVITY"));
        Assert.assertThat((Object)ReconnectableConnectionProvider.fail, (Matcher)Matchers.is((Object)true));
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    public static class AfterWithCallbackInterceptorFactory
    implements ProcessorInterceptorFactory {
        public ProcessorInterceptor get() {
            return new AfterWithCallbackInterceptor();
        }
    }

    public static class HasInjectedAttributesInterceptorFactory
    implements ProcessorInterceptorFactory {
        @Inject
        private MuleExpressionLanguage expressionEvaluator;
        @Inject
        private LockFactory lockFactory;
        @Inject
        private HttpService httpService;
        @Inject
        private ErrorTypeRepository errorTypeRepository;
        @Inject
        private SchedulerService schedulerService;
        @Inject
        private Registry registry;
        private final boolean mutateEventBefore;

        public HasInjectedAttributesInterceptorFactory(boolean mutateEventBefore) {
            this.mutateEventBefore = mutateEventBefore;
        }

        public ProcessorInterceptor get() {
            return new HasInjectedAttributesInterceptor(this.expressionEvaluator, this.lockFactory, this.httpService, this.errorTypeRepository, this.schedulerService, this.registry, this.mutateEventBefore);
        }
    }

    public static class EvaluatesExpressionInterceptorFactory
    implements ProcessorInterceptorFactory {
        @Inject
        private MuleExpressionLanguage expressionEvaluator;

        public ProcessorInterceptor get() {
            return new EvaluatesExpressionInterceptor(this.expressionEvaluator);
        }

        public boolean intercept(ComponentLocation location) {
            return location.getLocation().startsWith("expressionsInInterception");
        }
    }

    public static class ErrorMappingRequiredInterceptorFactory
    implements ProcessorInterceptorFactory {
        public ProcessorInterceptor get() {
            return new ErrorMappingRequiredInterceptor();
        }
    }

    public static class HasInjectedAttributesInterceptor
    implements ProcessorInterceptor {
        static final List<InterceptionParameters> interceptionParameters = new LinkedList<InterceptionParameters>();
        private final MuleExpressionLanguage expressionEvaluator;
        private final LockFactory lockFactory;
        private final HttpService httpService;
        private final ErrorTypeRepository errorTypeRepository;
        private final SchedulerService schedulerService;
        private final Registry registry;
        private final boolean mutateEventBefore;

        public HasInjectedAttributesInterceptor(MuleExpressionLanguage expressionEvaluator, LockFactory lockFactory, HttpService httpService, ErrorTypeRepository errorTypeRepository, SchedulerService schedulerService, Registry registry, boolean mutateEventBefore) {
            this.expressionEvaluator = expressionEvaluator;
            this.lockFactory = lockFactory;
            this.httpService = httpService;
            this.errorTypeRepository = errorTypeRepository;
            this.schedulerService = schedulerService;
            this.registry = registry;
            this.mutateEventBefore = mutateEventBefore;
        }

        public synchronized void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            parameters.values().forEach(v -> {
                try {
                    v.resolveValue();
                }
                catch (ExpressionRuntimeException expressionRuntimeException) {
                    // empty catch block
                }
            });
            interceptionParameters.add(new InterceptionParameters(location, parameters, event));
            Assert.assertThat((Object)this.expressionEvaluator, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.lockFactory, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.httpService, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.errorTypeRepository, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.schedulerService, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            Assert.assertThat((Object)this.registry, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            if (this.mutateEventBefore) {
                event.addVariable("mutated", (Object)Math.random());
            }
        }
    }

    public static class AfterWithCallbackInterceptor
    implements ProcessorInterceptor {
        static BiConsumer<InterceptionEvent, Optional<Throwable>> callback = (event, thrown) -> {};

        public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
            callback.accept(event, thrown);
        }
    }

    public static class InterceptionParameters {
        private final ComponentLocation location;
        private final Map<String, ProcessorParameterValue> parameters;
        private final InterceptionEvent event;

        public InterceptionParameters(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            this.location = location;
            this.parameters = parameters;
            this.event = event;
        }

        public ComponentLocation getLocation() {
            return this.location;
        }

        public Map<String, ProcessorParameterValue> getParameters() {
            return this.parameters;
        }

        public InterceptionEvent getEvent() {
            return this.event;
        }

        public String toString() {
            return "InterceptionParameters{location: '" + this.location.getLocation() + "'; parameters: " + this.parameters + "}";
        }
    }

    public static class ErrorMappingRequiredInterceptor
    implements ProcessorInterceptor {
        static Function<ComponentLocation, Boolean> callback = location -> false;

        public boolean isErrorMappingRequired(ComponentLocation location) {
            return callback.apply(location);
        }

        public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
        }
    }

    public static class EvaluatesExpressionInterceptor
    implements ProcessorInterceptor {
        private final MuleExpressionLanguage expressionEvaluator;

        public EvaluatesExpressionInterceptor(MuleExpressionLanguage expressionEvaluator) {
            this.expressionEvaluator = expressionEvaluator;
        }

        public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            parameters.values().forEach(ProcessorParameterValue::resolveValue);
            try {
                this.expressionEvaluator.evaluate("vars.addedVar", event.asBindingContext());
            }
            catch (ExpressionRuntimeException e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Unable to resolve reference of addedVar"));
            }
            event.addVariable("addedVar", (Object)"value1");
            Assert.assertThat((Object)this.expressionEvaluator.evaluate("vars.addedVar", event.asBindingContext()).getValue(), (Matcher)Matchers.is((Object)"value1"));
            event.addVariable("addedVar", (Object)"value2");
            Assert.assertThat((Object)this.expressionEvaluator.evaluate("vars.addedVar", event.asBindingContext()).getValue(), (Matcher)Matchers.is((Object)"value2"));
        }
    }
}

