/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.dsl;

import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.pojos.ParameterCollectionParser;

public class PropertiesTestCase
extends AbstractIntegrationTestCase {
    public static final String SYSTEM_PROPERTY_VALUE = "systemPropertyValue";
    @Rule
    public SystemProperty lastnameSystemProperty = new SystemProperty("systemProperty", "systemPropertyValue");
    @Rule
    public SystemProperty ageSystemProperty = new SystemProperty("testPropertyOverrided", "10");

    protected String getConfigFile() {
        return "org/mule/test/dsl/properties-config.xml";
    }

    @Test
    public void propertiesAreCorrectlyConfigured() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("testObject").get();
        Assert.assertThat((Object)parsersTestObject.getFirstname(), (Matcher)Is.is((Object)"testPropertyValue"));
        Assert.assertThat((Object)parsersTestObject.getLastname(), (Matcher)Is.is((Object)SYSTEM_PROPERTY_VALUE));
        Assert.assertThat((Object)parsersTestObject.getAge(), (Matcher)Is.is((Object)10));
    }

    @Test
    @Issue(value="MULE-19271")
    public void configurationPropertiesAreCorrectlyConfigured() {
        Assert.assertThat((Object)muleContext.getConfiguration().getDefaultResponseTimeout(), (Matcher)Is.is((Object)1000));
    }
}

