/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.tck.processor.FlowAssert;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class NonBlockingFunctionalTestCase
extends AbstractIntegrationTestCase {
    private final String config;
    private final String processingStrategyFactory;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Local Error Handler with Default PS", "non-blocking-test-config.xml", "org.mule.runtime.core.internal.processor.strategy.TransactionAwareStreamEmitterProcessingStrategyFactory"}, {"Global Error Handler with Default PS", "non-blocking-test-config-global-err.xml", "org.mule.runtime.core.internal.processor.strategy.TransactionAwareStreamEmitterProcessingStrategyFactory"}, {"Local Error Handler with Proactor PS", "non-blocking-test-config.xml", "org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamEmitterProcessingStrategyFactory"}, {"Global Error Handler with Proactor PS", "non-blocking-test-config-global-err.xml", "org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamEmitterProcessingStrategyFactory"});
    }

    public NonBlockingFunctionalTestCase(String type, String config, String processingStrategyFactory) {
        this.config = config;
        this.processingStrategyFactory = processingStrategyFactory;
    }

    protected String[] getConfigFiles() {
        return new String[]{"org/mule/engine/non-blocking-test-common-config.xml", "org/mule/engine/" + this.config};
    }

    protected void doSetUpBeforeMuleContextCreation() {
        this.setDefaultProcessingStrategyFactory("org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamEmitterProcessingStrategyFactory");
    }

    protected void doTearDownAfterMuleContextDispose() {
        this.clearDefaultProcessingStrategyFactory();
    }

    @Test
    public void flow() throws Exception {
        ((FlowRunner)this.flowRunner("flow").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void subFlow() throws Exception {
        ((FlowRunner)this.flowRunner("subFlow").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void childFlow() throws Exception {
        ((FlowRunner)this.flowRunner("childFlow").withPayload((Object)"Test Message")).run();
    }

    public void childAsyncFlow() throws Exception {
        ((FlowRunner)this.flowRunner("childAsyncFlow").withPayload((Object)"Test Message")).run();
        FlowAssert.verify((String)"childAsyncFlowChild");
    }

    @Test
    public void processorChain() throws Exception {
        ((FlowRunner)this.flowRunner("processorChain").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void choice() throws Exception {
        ((FlowRunner)this.flowRunner("choice").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void async() throws Exception {
        ((FlowRunner)this.flowRunner("async").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void catchExceptionStrategy() throws Exception {
        ((FlowRunner)this.flowRunner("catchExceptionStrategy").withPayload((Object)"Test Message")).run();
        FlowAssert.verify((String)"catchExceptionStrategyChild");
    }

    @Test
    public void rollbackExceptionStrategy() throws Exception {
        ((FlowRunner)this.flowRunner("rollbackExceptionStrategy").withPayload((Object)"Test Message")).run();
        FlowAssert.verify((String)"rollbackExceptionStrategyChild");
    }

    @Test
    public void nonTransactionalTry() throws Exception {
        ((FlowRunner)this.flowRunner("nonTransactionalTry").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void nonTransactionalTryErrorHandler() throws Exception {
        ((FlowRunner)this.flowRunner("nonTransactionalTryErrorHandler").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void transactionalTry() throws Exception {
        String flowName = "transactionalTry";
        if ("org.mule.runtime.core.internal.processor.strategy.TransactionAwareProactorStreamEmitterProcessingStrategyFactory".equals(this.processingStrategyFactory)) {
            flowName = flowName + "Proactor";
        } else if ("org.mule.runtime.core.internal.processor.strategy.TransactionAwareStreamEmitterProcessingStrategyFactory".equals(this.processingStrategyFactory)) {
            flowName = flowName + "Emitter";
        } else {
            Assert.fail((String)("Unknown processingStrategyFactory " + this.processingStrategyFactory));
        }
        ((FlowRunner)this.flowRunner(flowName).withPayload((Object)"Test Message")).run();
    }

    @Test
    public void transactionalTryErrorHandler() throws Exception {
        ((FlowRunner)this.flowRunner("transactionalTryErrorHandler").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void childDefaultFlow() throws Exception {
        ((FlowRunner)this.flowRunner("childDefaultFlow").withPayload((Object)"Test Message")).run();
        FlowAssert.verify((String)"childDefaultFlowChild");
    }

    @Test
    public void untilSuccessfulNoRetry() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessfulNoRetry").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulNoRetryNonBlockingAfterScope() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessfulNoRetryNonBlockingAfterScope").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulWithRetryExceptionBefore() throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(2);
        ((FlowRunner)((FlowRunner)this.flowRunner("untilSuccessfulWithRetryExceptionBefore").withVariable("counter", (Object)countDownLatch)).withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulWithRetryExceptionAfter() throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(2);
        ((FlowRunner)((FlowRunner)this.flowRunner("untilSuccessfulWithRetryExceptionAfter").withVariable("counter", (Object)countDownLatch)).withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulWithRetryNonBlockingAfterScope() throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(2);
        ((FlowRunner)((FlowRunner)this.flowRunner("untilSuccessfulWithRetryNonBlockingAfterScope").withVariable("counter", (Object)countDownLatch)).withPayload((Object)"Test Message")).run();
    }

    @Test
    public void untilSuccessfulWithRetryTransactional() throws Exception {
        TransactionCoordination.getInstance().bindTransaction((Transaction)Mockito.mock(Transaction.class));
        CountDownLatch countDownLatch = new CountDownLatch(2);
        ((FlowRunner)((FlowRunner)this.flowRunner("untilSuccessfulWithRetryTransactional").withVariable("counter", (Object)countDownLatch)).withPayload((Object)"Test Message")).run();
    }

    public static Object countdownLatch(Object payload, CountDownLatch latch) {
        latch.countDown();
        return payload;
    }

    @Test
    public void foreach() throws Exception {
        ((FlowRunner)this.flowRunner("foreach").withPayload(Arrays.asList({"1", "2", "3"}, {"a", "b", "c"}))).run();
    }

    @Test
    public void untilSuccessful() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessful").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void forEachAndUntilSuccessful() throws Exception {
        ((FlowRunner)this.flowRunner("foreach_and_untilSuccessful").withPayload(Arrays.asList({"1", "2", "3"}, {"a", "b", "c"}))).run();
    }

    @Test
    public void untilSuccessfulAndForeach() throws Exception {
        ((FlowRunner)this.flowRunner("untilSuccessful_and_foreach").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void scatterGather() throws Exception {
        this.flowRunner("scatterGather").run();
    }

    @Test
    public void parallelForeach() throws Exception {
        ((FlowRunner)this.flowRunner("parallelForeach").withPayload(Arrays.asList({"1", "2", "3"}, {"a", "b", "c"}))).run();
    }
}

