/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.locator;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import org.junit.Test;
import org.mule.runtime.api.component.location.Location;
import org.mule.test.integration.locator.AbstractLazyInitConfigurationComponentLocatorTestCase;

@Features(value={@Feature(value="Lazy Initialization"), @Feature(value="Configuration component locator")})
@Story(value="Search configuration")
public class LazyInitAdditionalComponentTestCase
extends AbstractLazyInitConfigurationComponentLocatorTestCase {
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("flowFailing").build());
        this.assertFlowsInitialized("flowFailing");
        this.assertLocationsInitialized("flowFailing", "flowFailing/processors/0");
        this.assertLocationsNotInitialized("anotherFlow");
    }

    @Test
    public void whenInitializeAdditionalComponentThenPreviousComponentsAreNotDisposed() {
        this.registry.lookupByName("anotherFlow");
        this.assertFlowsInitialized("flowFailing", "anotherFlow");
        this.assertLocationsInitialized("flowFailing", "flowFailing/processors/0", "anotherFlow", "anotherFlow/source");
        this.assertLocationsNotInitialized("justAnotherFlowThatShouldNotBeInitialized");
    }

    @Test
    public void whenInitializeComponentsAfterInitializeAdditionalThenPreviousComponentsAreDisposed() {
        this.registry.lookupByName("anotherFlow");
        this.assertFlowsInitialized("flowFailing", "anotherFlow");
        this.assertLocationsInitialized("flowFailing", "flowFailing/processors/0", "anotherFlow", "anotherFlow/source");
        this.assertLocationsNotInitialized("justAnotherFlowThatShouldNotBeInitialized");
        this.lazyComponentInitializer.initializeComponent(Location.builderFromStringRepresentation((String)"flowFailing").build());
        this.assertFlowsInitialized("flowFailing");
        this.assertLocationsInitialized("flowFailing");
        this.assertLocationsNotInitialized("myFlow", "myFlow/source", "anotherFlow", "anotherFlow/source");
    }

    @Description(value="Initialize same flow with redelivery policy configured in a listener, test component should not fail when initializing the second time")
    @Test
    public void whenInitializingComponentsDependingOnComponentsAlreadyInitializedItDoesNotFail() {
        this.assertLocationsNotInitialized("redeliveryPolicyFlowRef1", "redeliveryPolicyFlowRef2", "redeliveryPolicyFlow", "listenerConfigRedeliveryPolicy");
        this.invokeInitializer(Location.builder().globalName("redeliveryPolicyFlowRef1").build());
        this.invokeInitializer(Location.builder().globalName("redeliveryPolicyFlowRef2").build());
        this.assertLocationsInitialized("redeliveryPolicyFlowRef1", "redeliveryPolicyFlowRef2", "redeliveryPolicyFlow", "listenerConfigRedeliveryPolicy");
    }

    @Override
    protected void invokeInitializer(Location location) {
        this.registry.lookupByName(location.toString());
    }
}

