/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class TransactionRollbackedByOwnerTestCase
extends AbstractIntegrationTestCase {
    private static final int POLL_DELAY_MILLIS = 100;
    @Inject
    private PrivilegedProfilingService service;
    private List<String> states;
    private final String flowName;
    private final List<String> expectedStates;
    private final boolean throwsMessagingException;
    private final String config;
    private final boolean ignoreExtraStates;
    @ClassRule
    public static SystemProperty enableProfilingService = new SystemProperty("mule.enable.profiling.service", "true");
    @ClassRule
    public static SystemProperty enableProfilingConsumers = new SystemProperty("mule.force.runtime.profiling.consumers.enablement", "true");
    @Rule
    public SystemProperty defaultErrorHandler = new SystemProperty("mule.enable.default.errorhandler.not.rollback.incorrect.tx", "true");

    @Parameterized.Parameters(name="{0} - {2}")
    public static Object[][] params() {
        return new Object[][]{{"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback", false, Arrays.asList("start", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "rollback", true, Arrays.asList("start", "rollback"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-outside-try", true, Arrays.asList("start", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-flowref", false, Arrays.asList("start", "continue", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-error-in-flow-ref", false, Arrays.asList("start", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "rollback-error-in-flow-ref-with-try", true, Arrays.asList("start", "continue", "rollback"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-error-in-flow-ref-with-try", false, Arrays.asList("start", "continue", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "no-rollback-error-in-flow-ref-with-try-join-tx", false, Arrays.asList("start", "continue", "continue", "continue", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-implicit-default-EH-executed-commits", false, Arrays.asList("start", "continue", "continue", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-implicit-default-EH-executed-rollback", true, Arrays.asList("start", "continue", "continue", "rollback"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-default-EH-executed-commits", false, Arrays.asList("start", "continue", "continue", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner.xml", "with-default-EH-executed-rollback", false, Arrays.asList("start", "rollback"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-on-error-prop", false, Arrays.asList("start", "rollback"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-default-on-error-prop", true, Arrays.asList("start", "rollback"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-in-flow", true, Arrays.asList("start", "rollback"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "commit-flow-on-error-continue", false, Arrays.asList("start", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-nested-subflows", true, Arrays.asList("start", "rollback"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "commit-nested-subflows", false, Arrays.asList("start", "commit"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "rollback-nested-flows", true, Arrays.asList("start", "continue", "rollback"), false}, {"Local Error Handler", "org/mule/test/integration/transaction/transaction-owner-subflow.xml", "commit-nested-flows", false, Arrays.asList("start", "continue", "commit"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback", false, Arrays.asList("start", "commit"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback", false, Arrays.asList("start", "rollback"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-outside-try", true, Arrays.asList("start", "commit"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-flowref", false, Arrays.asList("start", "continue", "commit"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flow-ref", false, Arrays.asList("start", "commit"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-flow-ref-with-try", true, Arrays.asList("start", "rollback"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flow-ref-with-try", false, Arrays.asList("start", "continue", "commit"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-flow-ref-with-nested-try", false, Arrays.asList("start", "rollback"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flow-ref-with-nested-try", false, Arrays.asList("start", "continue", "continue", "continue", "commit"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "no-rollback-error-in-flow-ref-with-try-join-tx", false, Arrays.asList("start", "continue", "continue", "continue", "commit"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-nested-try", true, Arrays.asList("start", "continue", "continue", "rollback"), false}, {"Global Error Handler", "org/mule/test/integration/transaction/transaction-owner-global-err.xml", "rollback-error-in-nested-try-with-same-error-handler", true, Arrays.asList("start", "continue", "continue", "rollback"), false}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback", true, Arrays.asList("start", "rollback"), false}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "no-rollback-outside-try", true, Arrays.asList("start", "commit"), false}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-error-in-flow-ref-with-try", true, Arrays.asList("start", "rollback"), false}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "rollback-error-in-flow-ref-with-nested-try", false, Arrays.asList("start", "rollback"), false}, {"Default Error Handler", "org/mule/test/integration/transaction/transaction-owner-default-err.xml", "no-rollback-error-in-flow-ref-with-nested-try", false, Arrays.asList("start", "continue", "continue", "continue", "commit"), false}};
    }

    public TransactionRollbackedByOwnerTestCase(String type, String config, String flowName, boolean throwsMessagingException, List<String> expectedStates, boolean ignoreExtraStates) {
        this.flowName = flowName;
        this.expectedStates = expectedStates;
        this.throwsMessagingException = throwsMessagingException;
        this.config = config;
        this.ignoreExtraStates = ignoreExtraStates;
    }

    protected String getConfigFile() {
        return this.config;
    }

    protected void doSetUp() throws Exception {
        this.states = new ArrayList<String>();
        this.service.registerProfilingDataConsumer((ProfilingDataConsumer)new ProfilingDataConsumer<TransactionProfilingEventContext>(){

            public void onProfilingEvent(ProfilingEventType<TransactionProfilingEventContext> profilingEventType, TransactionProfilingEventContext profilingEventContext) {
                TransactionRollbackedByOwnerTestCase.this.states.add(profilingEventType.toString());
            }

            public Set<ProfilingEventType<TransactionProfilingEventContext>> getProfilingEventTypes() {
                HashSet<ProfilingEventType<TransactionProfilingEventContext>> events = new HashSet<ProfilingEventType<TransactionProfilingEventContext>>();
                events.add(RuntimeProfilingEventTypes.TX_START);
                events.add(RuntimeProfilingEventTypes.TX_COMMIT);
                events.add(RuntimeProfilingEventTypes.TX_CONTINUE);
                events.add(RuntimeProfilingEventTypes.TX_ROLLBACK);
                return events;
            }

            public Predicate<TransactionProfilingEventContext> getEventContextFilter() {
                return tx -> true;
            }
        });
    }

    @Test
    public void checkRollback() {
        block3: {
            try {
                ((FlowRunner)this.flowRunner(this.flowName).withPayload((Object)"message")).run();
                if (this.throwsMessagingException) {
                    Assert.fail((String)"Should have thrown Exception from unhandled error");
                }
            }
            catch (Exception e) {
                if (this.throwsMessagingException) break block3;
                Assert.fail((String)"Should have not thrown Exception from handled error");
            }
        }
        this.assertStatesArrived();
        this.assertCorrectStates();
    }

    private void assertStatesArrived() {
        PollingProber pollingProber = new PollingProber(5000L, 100L);
        pollingProber.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                MatcherAssert.assertThat((Object)TransactionRollbackedByOwnerTestCase.this.states.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
                return true;
            }

            public String describeFailure() {
                return "States did not arrive";
            }
        });
    }

    private void assertCorrectStates() {
        if (this.ignoreExtraStates) {
            for (int i = 0; i < this.expectedStates.size(); ++i) {
                MatcherAssert.assertThat((Object)this.states.get(i), (Matcher)Matchers.is((Object)this.expectedStates.get(i)));
            }
        } else {
            MatcherAssert.assertThat(this.states, (Matcher)Matchers.contains((Object[])this.expectedStates.toArray()));
        }
    }
}

