/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Error Handling")
@Story(value="Global Error Handler")
public class TransactionWithGlobalErrorHandlerTestCase
extends AbstractIntegrationTestCase {
    private static final int EXECUTIONS = 10;
    private static final CountDownLatch latch = new CountDownLatch(10);
    private static final List<Transaction> transactions = new CopyOnWriteArrayList<Transaction>();
    private static final int PROBER_POLLING_INTERVAL = 100;
    private static final int PROBER_POLLING_TIMEOUT = 2000;

    protected String getConfigFile() {
        return "routers/transaction-global-eh.xml";
    }

    @Test
    public void commitsTransaction() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.flowRunner("execute").run();
        }
        latch.await();
        new PollingProber(2000L, 100L).check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                MatcherAssert.assertThat((Object)transactions, (Matcher)Matchers.hasSize((int)10));
                for (Transaction tx : transactions) {
                    MatcherAssert.assertThat((Object)tx.isCommitted(), (Matcher)CoreMatchers.is((Object)true));
                }
                return true;
            }
        });
    }

    public static class Operation
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            if (TransactionCoordination.isTransactionActive()) {
                transactions.add(TransactionCoordination.getInstance().getTransaction());
            }
            latch.countDown();
            return event;
        }
    }
}

