/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.interception;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedResult;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.VerboseExceptions;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.integration.interception.ProcessorInterceptorFactoryTestCase;

@Feature(value="Interception API")
@Story(value="Component Interception Story")
public class ProcessorInterceptorFactoryChainTestCase
extends AbstractIntegrationTestCase {
    @ClassRule
    public static VerboseExceptions verboseExceptions = new VerboseExceptions(false);
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @Rule
    public DynamicPort wireMockPort = new DynamicPort("wireMockPort");
    @Rule
    public WireMockRule wireMock = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().bindAddress("127.0.0.1").port(this.wireMockPort.getNumber()));

    @Before
    public void setUp() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/404")).willReturn(WireMock.aResponse().withStatus(404)));
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/418")).willReturn(WireMock.aResponse().withStatus(418)));
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/interception/processor-interceptor-factory.xml";
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put("_AfterWithCallbackInterceptorFactory", new AfterWithCallbackInterceptorFactory());
        objects.put("_ExecutesOperationInnerChainInterceptorFactory", new ExecutesTapPhonesOperationInnerChainInterceptorFactory(Arrays.asList("operationWithChainAndCallback")));
        objects.put("_muleProcessorInterceptorFactoryOrder", () -> Arrays.asList(ExecutesTapPhonesOperationInnerChainInterceptorFactory.class.getName(), AfterWithCallbackInterceptor.class.getName()));
        return objects;
    }

    @Test
    public void operationWithChain() throws Exception {
        this.flowRunner("operationWithChain").run();
    }

    @Test
    @Issue(value="MULE-18501")
    public void operationWithChainFailingLogsCorrectly() throws Exception {
        this.flowRunner("operationWithChainFailing").run();
    }

    @Test
    @Issue(value="MULE-18099")
    public void operationWithChainAndCallback() throws Exception {
        AtomicBoolean afterCallbackCalled = new AtomicBoolean(false);
        ProcessorInterceptorFactoryTestCase.AfterWithCallbackInterceptor.callback = (interceptionEvent, throwable) -> afterCallbackCalled.getAndSet(true);
        try {
            this.flowRunner("operationWithChainAndCallback").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalled.get(), (Matcher)Matchers.is((Object)true));
        }
    }

    @Test
    @Issue(value="W-15314786")
    public void operationWithRouterChainAndCallback() throws Exception {
        AtomicBoolean afterCallbackCalled = new AtomicBoolean(false);
        ProcessorInterceptorFactoryTestCase.AfterWithCallbackInterceptor.callback = (interceptionEvent, throwable) -> afterCallbackCalled.getAndSet(true);
        try {
            this.flowRunner("operationWithRouterChainAndCallback").run();
        }
        finally {
            Assert.assertThat((Object)afterCallbackCalled.get(), (Matcher)Matchers.is((Object)true));
        }
    }

    public static class ExecutesOperationInnerChainInterceptor
    implements ProcessorInterceptor {
        public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
            ProcessorParameterValue operationsParam = parameters.get("operations");
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference thrownByChain = new AtomicReference();
            ((Chain)operationsParam.resolveValue()).process(EventedResult.builder((Message)event.getMessage()).build(), result -> latch.countDown(), (error, result) -> {
                thrownByChain.set(error);
                latch.countDown();
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            if (thrownByChain.get() != null) {
                throw new RuntimeException((Throwable)thrownByChain.get());
            }
        }

        public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
            return action.skip();
        }
    }

    public static class AfterWithCallbackInterceptor
    implements ProcessorInterceptor {
        static BiConsumer<InterceptionEvent, Optional<Throwable>> callback = (event, thrown) -> {};

        public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
            callback.accept(event, thrown);
        }
    }

    public static class AfterWithCallbackInterceptorFactory
    implements ProcessorInterceptorFactory {
        public ProcessorInterceptor get() {
            return new ProcessorInterceptorFactoryTestCase.AfterWithCallbackInterceptor();
        }
    }

    public static class ExecutesTapPhonesOperationInnerChainInterceptorFactory
    implements ProcessorInterceptorFactory {
        private List<String> excludeRootLocations;

        public ExecutesTapPhonesOperationInnerChainInterceptorFactory(List<String> excludeRootLocations) {
            this.excludeRootLocations = excludeRootLocations;
        }

        public boolean intercept(ComponentLocation location) {
            return "tap-phones".equals(location.getComponentIdentifier().getIdentifier().getName()) && this.excludeRootLocations.stream().noneMatch(rootLocation -> location.getLocation().startsWith((String)rootLocation));
        }

        public ProcessorInterceptor get() {
            return new ExecutesOperationInnerChainInterceptor();
        }
    }
}

