/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
@Feature(value="Logging")
@Story(value="Error Reporting")
public class ForkJoinRoutersLogCheckTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public SystemProperty detailedCompositeRoutingExceptionLog;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/fork-join-routers-log-config.xml";
    }

    @Parameterized.Parameters(name="Detailed log: {0}")
    public static List<Object[]> parameters() {
        return Arrays.asList({true}, {false});
    }

    public ForkJoinRoutersLogCheckTestCase(boolean detailedCompositeRoutingExceptionLog) {
        this.detailedCompositeRoutingExceptionLog = new SystemProperty("mule.detailedCompositeRoutingExceptionLog", Boolean.toString(detailedCompositeRoutingExceptionLog));
    }

    @Test
    @Issue(value="W-10965130")
    public void compositeRoutingExceptionForParallelForEach() throws Exception {
        if (Boolean.parseBoolean(this.detailedCompositeRoutingExceptionLog.getValue())) {
            this.runSuccesses("parallelForEachFlow");
        } else {
            this.runSuccesses("previousParallelForEachFlow");
        }
    }

    @Test
    @Issue(value="W-10965130")
    public void compositeRoutingExceptionForScatterGather() throws Exception {
        if (Boolean.parseBoolean(this.detailedCompositeRoutingExceptionLog.getValue())) {
            this.runSuccesses("scatterGatherFlow");
        } else {
            this.runSuccesses("previousScatterGatherFlow");
        }
    }

    private void runSuccesses(String flowName) throws Exception {
        this.flowRunner(flowName).run();
    }
}

