/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="Error Handling")
@Story(value="When expression for error handler")
@RunnerDelegateTo(value=Parameterized.class)
public class OnErrorWithTypeAndWhenExpressionTestCase
extends AbstractIntegrationTestCase {
    private String flowName;
    private boolean expectFailure;
    @Rule
    public ExpectedError expectedException = ExpectedError.none();

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/on-error-when-expression.xml";
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"withType", false}, {"withIncorrectType", false}, {"withWhen", false}, {"withIncorrectWhen", false}, {"withWhenAndType", false}, {"withCorrectWhenIncorrectType", false}, {"withIncorrectWhenCorrectType", false}, {"withIncorrectWhenIncorrectType", false}, {"defaultWhenConditionNotMet", true});
    }

    public OnErrorWithTypeAndWhenExpressionTestCase(String flowName, boolean expectFailure) {
        this.flowName = flowName;
        this.expectFailure = expectFailure;
    }

    @Test
    public void runTest() throws Exception {
        if (this.expectFailure) {
            this.expectedException.expectMessage(CoreMatchers.containsString((String)"An error occurred"));
        }
        CoreEvent event = this.flowRunner(this.flowName).run();
        MatcherAssert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"Correct"));
    }
}

