/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Error Handling")
@Story(value="Default Error Handler")
public class DefaultErrorHandlerTestCase
extends AbstractIntegrationTestCase {
    private static Exception exception;

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/default-error-handler-config.xml";
    }

    @Test
    public void defaultCustomIsUsedWhenCatchAllMissingAndNoMatch() throws Exception {
        this.verifyWithException((Exception)new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error")), "defaultEH-custom");
    }

    @Test
    public void defaultAllIsUsedWhenCatchAllMissingAndNoMatch() throws Exception {
        this.verifyWithException(new RuntimeException("Error"), "defaultEH-all");
    }

    @Test
    public void flowIsUsedWhenCatchAllIsMissingButMatchFound() throws Exception {
        this.verifyWithException((Exception)new RetryPolicyExhaustedException(I18nMessageFactory.createStaticMessage((String)"Error"), Mockito.mock(Initialisable.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Component.class}))), "innerEH");
    }

    private void verifyWithException(Exception exceptionToThrow, String expectedPayload) throws Exception {
        exception = exceptionToThrow;
        Assert.assertThat((Object)((FlowRunner)this.flowRunner("test").withPayload((Object)"")).run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.is((Object)expectedPayload)));
    }

    protected static class ThrowExceptionProcessor
    implements Processor {
        protected ThrowExceptionProcessor() {
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw (MuleException)exception;
        }
    }
}

