/*
 * Decompiled with CFR 0.152.
 */
package org.mule.http.request;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.utils.UriCache;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP Service")
@Story(value="Request Builder")
public class HttpRequestBuilderTestCase
extends AbstractMuleTestCase {
    public static final String URI_VALUE = "someUri";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private HttpRequestBuilder builder = HttpRequest.builder();
    private String name = "name";
    private String value = "value";

    @Test
    public void defaultRequest() {
        URI uri = UriCache.getUriFromString((String)URI_VALUE);
        HttpRequest request = this.builder.uri(uri).build();
        Assert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)"GET"));
        Assert.assertThat((Object)request.getUri(), (Matcher)Matchers.is((Object)uri));
        Assert.assertThat((Object)request.getEntity(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyHttpEntity.class)));
        Assert.assertThat((Object)request.getHeaderNames(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)request.getQueryParams().keySet(), (Matcher)Matchers.empty());
    }

    @Test
    public void requestFromUriString() {
        HttpRequest request = this.builder.uri("http://localhost:8081/somePath/here").build();
        Assert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)"GET"));
        Assert.assertThat((Object)request.getPath(), (Matcher)Matchers.is((Object)"/somePath/here"));
        Assert.assertThat((Object)request.getEntity(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyHttpEntity.class)));
        Assert.assertThat((Object)request.getHeaderNames(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)request.getQueryParams().keySet(), (Matcher)Matchers.empty());
    }

    @Test
    public void syntheticRequest() {
        HttpRequest request = this.builder.uri("/somePath/here").build();
        Assert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)"GET"));
        Assert.assertThat((Object)request.getPath(), (Matcher)Matchers.is((Object)"/somePath/here"));
        Assert.assertThat((Object)request.getEntity(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(EmptyHttpEntity.class)));
        Assert.assertThat((Object)request.getHeaderNames(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)request.getQueryParams().keySet(), (Matcher)Matchers.empty());
    }

    @Test
    public void failWithoutUri() throws Exception {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"URI must be specified"));
        this.builder.build();
    }

    @Test
    public void complexResponse() {
        MultiMap paramMap = new MultiMap();
        paramMap.put((Object)this.name, (Object)this.value);
        HttpRequest request = ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)this.builder.entity((HttpEntity)new ByteArrayHttpEntity("test".getBytes()))).uri(URI_VALUE).method(HttpConstants.Method.POST).queryParams(paramMap).headers(paramMap)).addHeader(this.name.toUpperCase(), this.value.toUpperCase())).build();
        Assert.assertThat((Object)request.getUri(), (Matcher)Matchers.is((Object)URI.create(URI_VALUE)));
        Assert.assertThat((Object)request.getMethod(), (Matcher)Matchers.is((Object)HttpConstants.Method.POST.name()));
        Assert.assertThat((Object)request.getEntity(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ByteArrayHttpEntity.class)));
        Assert.assertThat((Object)request.getHeaderNames(), (Matcher)Matchers.hasItems((Object[])new String[]{this.name}));
        Assert.assertThat((Object)request.getHeaderValues(this.name), (Matcher)Matchers.hasItems((Object[])new String[]{this.value, this.value.toUpperCase()}));
        MultiMap requestQueryParams = request.getQueryParams();
        Assert.assertThat((Object)requestQueryParams.keySet(), (Matcher)Matchers.hasItems((Object[])new String[]{this.name}));
        Assert.assertThat((Object)requestQueryParams.getAll((Object)this.name), (Matcher)Matchers.hasItems((Object[])new String[]{this.value}));
    }

    @Test
    public void headerManipulation() {
        this.builder.uri(URI_VALUE);
        Assert.assertThat((Object)this.builder.build().getHeaderNames(), (Matcher)Matchers.empty());
        String otherValue = "otherValue";
        MultiMap multiMap = new MultiMap();
        multiMap.put((Object)this.name, (Object)this.value);
        multiMap.put((Object)this.name, (Object)otherValue);
        this.builder.headers(multiMap);
        this.builder.addHeader(this.name, this.value);
        Assert.assertThat((Object)this.builder.getHeaderValues(this.name), (Matcher)Matchers.hasItems((Object[])new String[]{this.value, otherValue, this.value}));
        Assert.assertThat((Object)this.builder.build().getHeaderValues(this.name), (Matcher)Matchers.hasItems((Object[])new String[]{this.value, otherValue, this.value}));
        this.builder.removeHeader(this.name);
        Assert.assertThat((Object)this.builder.build().getHeaderNames(), (Matcher)Matchers.empty());
    }

    @Test
    public void headerCheck() {
        HttpRequest request = ((HttpRequestBuilder)this.builder.uri(URI_VALUE).addHeader(this.name, this.value)).build();
        Assert.assertThat((Object)request.containsHeader(this.name), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)request.containsHeader("wat"), (Matcher)Matchers.is((Object)false));
    }
}

