/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class ExceptionHandlingSourceTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/exception-handling-source-test.xml";
    }

    @Before
    public void before() {
        OnErrorCounterProcessor.count.set(0);
    }

    @Test
    public void errorSendingResponse() throws Exception {
        HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.port.getNumber() + "/errorSendingResponse").method(HttpConstants.Method.GET).build();
        HttpResponse response = this.httpClient.send(request, 5000, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        Assert.assertThat((Object)OnErrorCounterProcessor.count.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void errorSendingErrorResponse() throws Exception {
        HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.port.getNumber() + "/errorSendingErrorResponse").method(HttpConstants.Method.GET).build();
        HttpResponse response = this.httpClient.send(request, 5000, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        Assert.assertThat((Object)OnErrorCounterProcessor.count.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void errorSendingThrownError() throws Exception {
        HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.port.getNumber() + "/errorSendingThrownError").method(HttpConstants.Method.GET).build();
        HttpResponse response = this.httpClient.send(request, 5000, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        Assert.assertThat((Object)OnErrorCounterProcessor.count.get(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void errorSendingErrorFromHandler() throws Exception {
        HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.port.getNumber() + "/errorSendingErrorFromHandler").method(HttpConstants.Method.GET).build();
        HttpResponse response = this.httpClient.send(request, 5000, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        Assert.assertThat((Object)OnErrorCounterProcessor.count.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void errorSendingPropagatedError() throws Exception {
        HttpRequest request = HttpRequest.builder().uri("http://localhost:" + this.port.getNumber() + "/errorSendingPropagatedError").method(HttpConstants.Method.GET).build();
        HttpResponse response = this.httpClient.send(request, 5000, false, null);
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        Assert.assertThat((Object)OnErrorCounterProcessor.count.get(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void errorInHandlerHasOrigin() throws Exception {
        MuleException exception = (MuleException)this.flowRunner("errorInHandlerHasOrigin").runExpectingException();
        Assert.assertThat((Object)((String)exception.getInfo().get("Element")), (Matcher)Matchers.containsString((String)"errorHandler/0/processors/0"));
        Assert.assertThat((Object)((String)exception.getInfo().get("Element DSL")), (Matcher)Matchers.containsString((String)"APP:EXPECTED_INSIDE_HANDLER"));
    }

    public static class OnErrorCounterProcessor
    extends AbstractComponent
    implements Processor {
        private static AtomicInteger count = new AtomicInteger(0);

        public CoreEvent process(CoreEvent event) throws MuleException {
            count.incrementAndGet();
            return event;
        }
    }
}

