/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.test.integration.lifecycle;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.functional.junit4.ApplicationContextBuilder;
import org.mule.functional.junit4.DomainContextBuilder;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

@Feature(value="Registry")
public class ApplicationWithDomainRegistryTestCase
extends AbstractMuleTestCase {
    public static final String BEAN_KEY = "someBean";
    public static final String ANOTHER_BEAN_KEY = "someOtherBean";
    private MuleContext domainContext;
    private MuleContext applicationContext;

    @Before
    public void createContexts() throws Exception {
        ArtifactContext domainArtifactContext = new DomainContextBuilder().setContextId(ApplicationWithDomainRegistryTestCase.class.getSimpleName() + "_domain").setDomainConfig(new String[]{"domain/empty-domain-config.xml"}).build();
        this.domainContext = domainArtifactContext.getMuleContext();
        this.applicationContext = new ApplicationContextBuilder().setContextId(ApplicationWithDomainRegistryTestCase.class.getSimpleName()).setDomainArtifactContext(domainArtifactContext).build();
    }

    @After
    public void disposeContexts() {
        if (this.domainContext != null) {
            this.domainContext.dispose();
            this.domainContext = null;
        }
        if (this.applicationContext != null) {
            this.applicationContext.dispose();
            this.applicationContext = null;
        }
    }

    @Story(value="Object Registration")
    @Test
    public void lookupByTypeSearchInParentAlso() throws Exception {
        LegacyRegistryUtils.registerObject((MuleContext)this.domainContext, (String)BEAN_KEY, (Object)BEAN_KEY);
        LegacyRegistryUtils.registerObject((MuleContext)this.applicationContext, (String)ANOTHER_BEAN_KEY, (Object)ANOTHER_BEAN_KEY);
        Collection values = LegacyRegistryUtils.lookupObjects((MuleContext)this.applicationContext, String.class);
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.hasSize((int)2));
    }

    @Story(value="Object Registration")
    @Test
    public void lookupByIdReturnsApplicationContextBeanEvenIfSameBeanIsInDomain() throws Exception {
        LegacyRegistryUtils.registerObject((MuleContext)this.applicationContext, (String)BEAN_KEY, (Object)BEAN_KEY);
        LegacyRegistryUtils.registerObject((MuleContext)this.domainContext, (String)BEAN_KEY, (Object)10);
        MatcherAssert.assertThat((Object)LegacyRegistryUtils.lookupObject((MuleContext)this.applicationContext, (String)BEAN_KEY), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(String.class)));
    }

    @Story(value="Object Registration")
    @Test
    public void lookupByLifecycleReturnsApplicationContextBeanOnly() throws Exception {
        LegacyRegistryUtils.registerObject((MuleContext)this.domainContext, (String)BEAN_KEY, (Object)BEAN_KEY);
        LegacyRegistryUtils.registerObject((MuleContext)this.applicationContext, (String)ANOTHER_BEAN_KEY, (Object)ANOTHER_BEAN_KEY);
        MatcherAssert.assertThat((Object)LegacyRegistryUtils.lookupObjectsForLifecycle((MuleContext)this.applicationContext, String.class).size(), (Matcher)Is.is((Object)1));
    }

    @Story(value="Object Registration")
    @Test
    public void lookupByIdReturnsParentApplicationContextBean() throws Exception {
        Object value = new Object();
        LegacyRegistryUtils.registerObject((MuleContext)this.applicationContext, (String)BEAN_KEY, (Object)value);
        MatcherAssert.assertThat((Object)LegacyRegistryUtils.lookupObject((MuleContext)this.applicationContext, (String)BEAN_KEY), (Matcher)Is.is((Object)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Story(value="Object Registration")
    @Test
    public void registerObjectAsynchronously() throws MuleException, InterruptedException, ExecutionException {
        Startable asyncStartableBean = (Startable)Mockito.mock(Startable.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Disposable.class}));
        Latch startingLatch = new Latch();
        Latch disposingLatch = new Latch();
        ((Startable)Mockito.doAnswer(invocation -> {
            startingLatch.countDown();
            MuleContext muleContext = this.applicationContext;
            synchronized (muleContext) {
                disposingLatch.await();
            }
            ((Disposable)Mockito.verify((Object)((Disposable)asyncStartableBean), (VerificationMode)Mockito.never())).dispose();
            return null;
        }).when((Object)asyncStartableBean)).start();
        ((Disposable)Mockito.doAnswer(invocation -> null).when((Object)asyncStartableBean)).dispose();
        ExecutorService threadPool = Executors.newCachedThreadPool();
        try {
            Future<?> submittedStop = threadPool.submit(() -> {
                try {
                    LegacyRegistryUtils.registerObject((MuleContext)this.applicationContext, (String)BEAN_KEY, (Object)asyncStartableBean);
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            });
            Future<?> submittedRegistryDispose = threadPool.submit(() -> {
                try {
                    startingLatch.await();
                }
                catch (InterruptedException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
                disposingLatch.countDown();
                MuleContext muleContext = this.applicationContext;
                synchronized (muleContext) {
                    this.applicationContext.dispose();
                    this.applicationContext = null;
                }
            });
            submittedRegistryDispose.get();
            submittedStop.get();
        }
        finally {
            threadPool.shutdownNow();
        }
        new PollingProber().check((Probe)new JUnitLambdaProbe(() -> {
            try {
                ((Startable)Mockito.verify((Object)asyncStartableBean)).start();
                ((Disposable)Mockito.verify((Object)((Disposable)asyncStartableBean))).dispose();
                return true;
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }));
    }
}

