/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.component.FunctionalTestProcessor;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.source.SchedulerMessageSource;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Scheduler Service")
@Story(value="Source Management")
public class SchedulerManagementTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private TestQueueManager queueManager;

    protected String getConfigFile() {
        return "org/mule/test/integration/scheduler-management-config.xml";
    }

    @Description(value="scheduler that never runs due to configuration but works by triggering it manually")
    @Test
    public void triggerSchedulerManually() {
        SchedulerMessageSource scheduler = (SchedulerMessageSource)muleContext.getConfigurationComponentLocator().find(Location.builder().globalName("neverRunningScheduler").addSourcePart().build()).get();
        scheduler.trigger();
        new PollingProber(10000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                CoreEvent response = SchedulerManagementTestCase.this.queueManager.read("neverRunningSchedulerQueue", 100L, TimeUnit.MILLISECONDS);
                return response != null;
            }

            public String describeFailure() {
                return "Message expected by triggering flow";
            }
        });
    }

    @Description(value="scheduler that runs once, gets stopped by a functional component within the same flow and the it's triggered manually")
    @Test
    public void stopSchedulerWithinFlowAndTriggerItManually() throws Exception {
        SchedulerMessageSource scheduler = (SchedulerMessageSource)SchedulerManagementTestCase.muleContext.getConfigurationComponentLocator().find(Location.builder().globalName("schedulerControlledFromSameFlow").addSourcePart().build()).get();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        Latch componentExecutedLatch = new Latch();
        FunctionalTestProcessor.getFromFlow((ConfigurationComponentLocator)this.locator, (String)"schedulerControlledFromSameFlow").setEventCallback((eventContext, component, muleContext) -> {
            scheduler.stop();
            atomicInteger.incrementAndGet();
            componentExecutedLatch.release();
        });
        if (!componentExecutedLatch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"test component never executed");
        }
        scheduler.trigger();
        new PollingProber(10000L, 100L).check(new Probe(){

            public boolean isSatisfied() {
                return atomicInteger.get() == 2;
            }

            public String describeFailure() {
                return "Executed two total executions of the flow but received " + atomicInteger.get();
            }
        });
    }

    @Description(value="scheduler start twice does not fail")
    @Test
    public void startTwiceDoesNotFail() throws MuleException {
        SchedulerMessageSource scheduler = (SchedulerMessageSource)muleContext.getConfigurationComponentLocator().find(Location.builder().globalName("schedulerControlledFromSameFlow").addSourcePart().build()).get();
        scheduler.start();
        scheduler.start();
    }

    @Description(value="scheduler stop twice does not fail")
    @Test
    public void stopTwiceDoesNotFail() throws MuleException {
        SchedulerMessageSource scheduler = (SchedulerMessageSource)muleContext.getConfigurationComponentLocator().find(Location.builder().globalName("schedulerControlledFromSameFlow").addSourcePart().build()).get();
        scheduler.stop();
        scheduler.stop();
    }
}

