/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.shutdown.AbstractShutdownTimeoutRequestResponseTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
public class ValidShutdownTimeoutOneWayTestCase
extends AbstractShutdownTimeoutRequestResponseTestCase {
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public SystemProperty contextShutdownTimeout = new SystemProperty("contextShutdownTimeout", "5000");

    protected String getConfigFile() {
        return "org/mule/shutdown/shutdown-timeout-one-way-config.xml";
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    @Test
    public void testStaticComponent() throws Throwable {
        this.doShutDownTest("staticComponentResponse", "staticComponentFlow");
    }

    @Test
    public void testScriptComponent() throws Throwable {
        this.doShutDownTest("scriptComponentResponse", "scriptComponentFlow");
    }

    @Test
    public void testSetPayload() throws Throwable {
        this.doShutDownTest("setPayloadResponse", "setPayloadFlow");
    }

    @Test
    public void testSetPayloadChoice() throws Throwable {
        this.doShutDownTest("setPayloadResponse", "setPayloadChoiceFlow");
    }

    @Test
    public void setPayloadThroughScatterGatherWithFlowRefs() throws Throwable {
        this.doShutDownTest("setPayloadResponse", "setPayloadThroughScatterGatherWithFlowRefs");
    }

    private void doShutDownTest(String payload, String flowName) throws Throwable {
        Future<?> requestTask = this.executor.submit(() -> {
            try {
                ((FlowRunner)this.flowRunner(flowName).withPayload((Object)payload)).dispatch();
            }
            catch (Exception e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        waitLatch.await();
        contextStopLatch.release();
        Message response = this.queueManager.read("response", 5000L, TimeUnit.MILLISECONDS).getMessage();
        if (response.getPayload().getDataType() instanceof MapDataType) {
            Map values = (Map)response.getPayload().getValue();
            values.entrySet().forEach(value -> {
                try {
                    Assert.assertThat((String)"Was not able to process message", (Object)this.getPayloadAsString((Message)value.getValue()), (Matcher)Matchers.is((Object)payload));
                }
                catch (Exception e) {
                    Assert.fail((String)"Was not able to process message");
                }
            });
        } else {
            Assert.assertThat((String)"Was not able to process message", (Object)this.getPayloadAsString(response), (Matcher)Matchers.is((Object)payload));
        }
        muleContext.stop();
        try {
            requestTask.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

