/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Pricing Metrics")
@Story(value="Lapsed message metrics")
public class FlowMessageStatisticsTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public SystemProperty muleEnableStatistics = new SystemProperty("mule.enable.statistics", "true");
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();
    private FlowConstructStatistics applicationStatistics;

    protected String getConfigFile() {
        return "org/mule/test/integration/flow-message-statistics-config.xml";
    }

    @Before
    public void setUp() {
        this.applicationStatistics = muleContext.getStatistics().getApplicationStatistics();
    }

    @Test
    public void withSource() throws Exception {
        HttpRequest request = HttpRequest.builder().uri(String.format("http://localhost:%s/withSource", this.port.getNumber())).method(HttpConstants.Method.POST).build();
        this.httpClient.send(request, HttpRequestOptions.builder().responseTimeout(5000).build());
        long totalMessagesDispatched = this.applicationStatistics.getTotalDispatchedMessages();
        long totalEventsReceived = this.applicationStatistics.getTotalEventsReceived();
        Assert.assertThat((Object)totalMessagesDispatched, (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)totalEventsReceived, (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void withSourceAndFlowRef() throws Exception {
        HttpRequest request = HttpRequest.builder().uri(String.format("http://localhost:%s/withSourceAndFlowRef", this.port.getNumber())).method(HttpConstants.Method.POST).build();
        this.httpClient.send(request, HttpRequestOptions.builder().responseTimeout(5000).build());
        long totalMessagesDispatched = this.applicationStatistics.getTotalDispatchedMessages();
        long totalEventsReceived = this.applicationStatistics.getTotalEventsReceived();
        Assert.assertThat((Object)totalMessagesDispatched, (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)totalEventsReceived, (Matcher)Matchers.is((Object)2L));
    }
}

