/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.classloading;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.test.AbstractIntegrationTestCase;

public class SdkApiClassloadingTestCase
extends AbstractIntegrationTestCase {
    private static final String OVERRIDEN_INTERFACE = "org.mule.sdk.api.runtime.connectivity.ReconnectionCallback";
    private static final String NEW_INTERFACE_NOT_PRESENT_IN_DISTRO = "org.mule.sdk.api.runtime.connectivity.NonExistingInterfaceInDistribution";
    private static final String METHOD_IN_NEW_INTERFACE = "doSomething";
    private static final String SUCCESS_METHOD_NAME = "success";
    private static final String FAILED_METHOD_NAME = "failed";

    protected String getConfigFile() {
        return "org/mule/test/integration/classloading/sdk-api-classloading-mule-config-flow.xml";
    }

    @Test
    public void sdkApiClassLoadingParentResolution() throws Exception {
        List methods = (List)((FlowRunner)this.flowRunner("getMethods").withPayload((Object)OVERRIDEN_INTERFACE)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)methods, (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)methods, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{SUCCESS_METHOD_NAME, FAILED_METHOD_NAME}));
    }

    @Test
    public void sdkApiClassLoadingChildResolution() throws Exception {
        List methods = (List)((FlowRunner)this.flowRunner("getMethods").withPayload((Object)NEW_INTERFACE_NOT_PRESENT_IN_DISTRO)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)methods, (Matcher)IsCollectionWithSize.hasSize((int)1));
        MatcherAssert.assertThat((Object)methods, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{METHOD_IN_NEW_INTERFACE}));
    }
}

