/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.component.FunctionalTestProcessor;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ClassNameMatcher;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

@Feature(value="Routers")
@Story(value="Until Successful")
public class UntilSuccessfulTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private FunctionalTestProcessor targetMessageProcessor;

    protected String getConfigFile() {
        return "until-successful-test.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.targetMessageProcessor = FunctionalTestProcessor.getFromFlow((ConfigurationComponentLocator)this.locator, (String)"target-mp");
    }

    protected void doTearDown() throws Exception {
        CustomMP.clearCount();
        super.doTearDown();
    }

    @Test
    public void executesOnceWhenNoErrorArises() throws Exception {
        CoreEvent response = this.flowRunner("happy-path-scope").run();
        Assert.assertThat((Object)this.getPayloadAsString(response.getMessage()), (Matcher)Is.is((Object)"pig"));
        Assert.assertThat((Object)this.queueManager.countPendingEvents("insideScope"), (Matcher)Is.is((Object)1));
    }

    @Test
    public void nestedUntilSuccessfulScopesExecutionTimes() throws Exception {
        CoreEvent response = this.flowRunner("nestedUntilSuccessfulScopes").run();
        Assert.assertThat((Object)this.getPayloadAsString(response.getMessage()), (Matcher)Is.is((Object)"holis"));
        Assert.assertThat((Object)this.queueManager.countPendingEvents("outerScope"), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.queueManager.countPendingEvents("innerScope"), (Matcher)Is.is((Object)6));
    }

    @Test
    public void scopeContinuesWorkingAfterErrorInMaxRetryExpression() throws Exception {
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 2; ++i) {
            ((FlowRunner)this.flowRunner("scope-with-max-retry-expr-and-err-continue").withVariable("maxRetries", (Object)"gato")).runExpectingException();
        }
        CoreEvent response = ((FlowRunner)this.flowRunner("scope-with-max-retry-expr-and-err-continue").withVariable("maxRetries", (Object)"1")).run();
        Assert.assertThat((Object)this.getPayloadAsString(response.getMessage()), (Matcher)Is.is((Object)"holis"));
    }

    @Test
    public void exceptionThrownFromInitializingRetryContextPropagates() throws Exception {
        this.expectedException.expectMessage(Matchers.containsString((String)"You called the function '+' with these arguments"));
        this.expectedException.expectCause(Matchers.instanceOf(ExpressionRuntimeException.class));
        ((FlowRunner)this.flowRunner("scope-with-max-retry-expr-and-err-continue").withVariable("maxRetries", (Object)"gato")).run();
    }

    @Test
    public void scopeHappyPathWithDifferentPayloads() throws Exception {
        Assert.assertThat((Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("us-with-no-errors").withPayload((Object)"perro")).run().getMessage()), (Matcher)Is.is((Object)"perro holis"));
        Assert.assertThat((Object)this.getPayloadAsString(((FlowRunner)this.flowRunner("us-with-no-errors").withPayload((Object)"gato")).run().getMessage()), (Matcher)Is.is((Object)"gato holis"));
    }

    @Test
    public void defaultConfiguration() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        ((FlowRunner)this.flowRunner("minimal-config").withPayload((Object)payload)).run();
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(1);
        Assert.assertThat(receivedPayloads, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)receivedPayloads.get(0), (Matcher)Is.is((Object)payload));
    }

    @Test
    public void fullConfigurationMP() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        Message response = ((FlowRunner)this.flowRunner("full-config-with-mp").withPayload((Object)payload)).run().getMessage();
        Assert.assertThat((Object)this.getPayloadAsString(response), (Matcher)Is.is((Object)"ACK"));
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(3);
        Assert.assertThat(receivedPayloads, (Matcher)IsCollectionWithSize.hasSize((int)3));
        for (int i = 0; i <= 2; ++i) {
            Assert.assertThat((Object)receivedPayloads.get(i), (Matcher)Is.is((Object)payload));
        }
        this.ponderUntilMessageCountReceivedByCustomMP(1);
        Error error = (Error)CustomMP.getProcessedEvents().get(0).getError().get();
        Assert.assertThat((Object)error.getErrorType().toString(), (Matcher)Matchers.equalTo((Object)"MULE:RETRY_EXHAUSTED"));
        Assert.assertThat((Object)error.getDescription(), (Matcher)Matchers.equalTo((Object)"Value was expected to be false but it was true instead"));
        Assert.assertThat((Object)error.getDetailedDescription(), (Matcher)Matchers.equalTo((Object)"'until-successful' retries exhausted"));
        Throwable errorCause = error.getCause();
        Assert.assertThat((Object)errorCause, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)errorCause, (Matcher)Matchers.instanceOf(RetryPolicyExhaustedException.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void withConcurrency() throws Exception {
        int times = Runtime.getRuntime().availableProcessors() * 2;
        ExecutorService runnerPool = Executors.newFixedThreadPool(times);
        try {
            for (int i = 0; i < times; ++i) {
                runnerPool.submit(() -> {
                    try {
                        ((FlowRunner)this.flowRunner("concurrency-error-handling").withPayload((Object)RandomStringUtils.randomAlphanumeric((int)20))).run();
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException((Throwable)e);
                    }
                });
            }
            this.ponderUntilMessageCountReceivedByCustomMP(times);
        }
        finally {
            runnerPool.shutdownNow();
        }
    }

    @Test
    public void retryOnEndpoint() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        ((FlowRunner)this.flowRunner("retry-endpoint-config").withPayload((Object)payload)).run();
        List<Object> receivedPayloads = this.ponderUntilMessageCountReceivedByTargetMessageProcessor(3);
        Assert.assertThat(receivedPayloads, (Matcher)IsCollectionWithSize.hasSize((int)3));
        for (int i = 0; i <= 2; ++i) {
            Assert.assertThat((Object)receivedPayloads.get(i), (Matcher)Is.is((Object)payload));
        }
    }

    @Test
    public void executeSynchronously() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        this.expectedException.expectCause(Matchers.instanceOf(RetryPolicyExhaustedException.class));
        this.expectedException.expect(ThrowableCauseMatcher.hasCause((Matcher)ThrowableCauseMatcher.hasCause((Matcher)ClassNameMatcher.hasClassName((Matcher)Matchers.containsString((String)"SuppressedMuleException")))));
        ((FlowRunner)this.flowRunner("synchronous").withPayload((Object)payload)).run();
    }

    @Test
    public void executeSynchronouslyDoingRetries() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        ((FlowRunner)this.flowRunner("synchronous-with-retry").withPayload((Object)payload)).runExpectingException();
        Assert.assertThat((Object)this.queueManager.countPendingEvents("untilSuccessful"), (Matcher)Is.is((Object)4));
        Assert.assertThat((Object)this.queueManager.countPendingEvents("exceptionStrategy"), (Matcher)Is.is((Object)1));
    }

    @Test
    public void executeSynchronouslyDoingExpressionRetries() throws Exception {
        this.flowRunner("synchronous-with-expression-retry").runExpectingException();
        Assert.assertThat((Object)this.queueManager.countPendingEvents("untilSuccessfulExpression"), (Matcher)Is.is((Object)6));
        Assert.assertThat((Object)this.queueManager.countPendingEvents("exceptionStrategyExpression"), (Matcher)Is.is((Object)1));
    }

    @Test
    public void executeWithoutRetrying() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        ((FlowRunner)this.flowRunner("synchronous-without-retry").withPayload((Object)payload)).runExpectingException();
        Assert.assertThat((Object)this.queueManager.countPendingEvents("untilSuccessfulNoRetry"), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.queueManager.countPendingEvents("exceptionStrategyNoRetry"), (Matcher)Is.is((Object)1));
    }

    @Test
    public void measureSynchronousWait() throws Exception {
        String payload = RandomStringUtils.randomAlphanumeric((int)20);
        ((FlowRunner)this.flowRunner("measureSynchronousWait").withPayload((Object)payload)).runExpectingException();
        Assert.assertThat((Object)(WaitMeasure.totalWait >= 1000L ? 1 : 0), (Matcher)Is.is((Object)true));
    }

    @Test
    @Description(value="Validates that until successful can be used correctly within an error handler")
    public void untilSuccessfulInErrorHandler() throws Exception {
        CoreEvent event = this.flowRunner("untilSuccessfulInErrorHandler").run();
        Assert.assertThat((Object)CustomMP.getCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)event.getMessage().getPayload().getValue(), (Matcher)Is.is((Object)"hello"));
    }

    private List<Object> ponderUntilMessageCountReceivedByTargetMessageProcessor(int expectedCount) throws InterruptedException {
        return this.ponderUntilMessageCountReceived(expectedCount, this.targetMessageProcessor);
    }

    private List<Object> ponderUntilMessageCountReceived(int expectedCount, FunctionalTestProcessor ftc) throws InterruptedException {
        ArrayList<Object> results = new ArrayList<Object>();
        new PollingProber(5000L, 200L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)ftc.getReceivedMessagesCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(expectedCount)));
            return true;
        }));
        for (int i = 0; i < ftc.getReceivedMessagesCount(); ++i) {
            results.add(ftc.getReceivedMessage(1 + i).getMessage().getPayload().getValue());
        }
        return results;
    }

    private void ponderUntilMessageCountReceivedByCustomMP(int expectedCount) throws InterruptedException {
        new PollingProber(5000L, 200L).check((Probe)new JUnitLambdaProbe(() -> {
            Assert.assertThat((Object)CustomMP.getCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(expectedCount)));
            return true;
        }));
    }

    public static class CustomMP
    implements Processor {
        private static List<CoreEvent> processedEvents = Collections.synchronizedList(new ArrayList());

        public static void clearCount() {
            processedEvents.clear();
        }

        public static int getCount() {
            return processedEvents.size();
        }

        public static List<CoreEvent> getProcessedEvents() {
            return processedEvents;
        }

        public CoreEvent process(CoreEvent event) throws MuleException {
            processedEvents.add(event);
            return event;
        }
    }

    public static class WaitMeasure
    implements Processor {
        public static long totalWait;
        private long firstAttemptTime = 0L;

        public CoreEvent process(CoreEvent event) throws MuleException {
            if (this.firstAttemptTime == 0L) {
                this.firstAttemptTime = System.currentTimeMillis();
            } else {
                totalWait = System.currentTimeMillis() - this.firstAttemptTime;
            }
            return event;
        }
    }
}

