/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import io.qameta.allure.Issue;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.privileged.routing.CompositeRoutingException;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.TestQueueManager;

public class CompositeRoutingExceptionSerializationTestCase
extends AbstractIntegrationTestCase {
    @Inject
    private TestQueueManager queueManager;
    @Inject
    private ObjectSerializer defaultSerializer;
    private static final String JAVA_FILENAME = "CompositeRoutingExceptionSerializationTestCase_testCanDeserializeCompositeRouterExceptionFromLegacyVersion.ser";

    private void verifyDeserializedError(Error deserializedError) {
        MatcherAssert.assertThat((Object)deserializedError.getCause(), (Matcher)CoreMatchers.instanceOf(CompositeRoutingException.class));
        MatcherAssert.assertThat((Object)deserializedError.getDescription(), (Matcher)CoreMatchers.containsString((String)"Route 0 failed - 474bab53-1135-4038-a894-b6ba646b3f00"));
        MatcherAssert.assertThat((Object)deserializedError.getDescription(), (Matcher)CoreMatchers.containsString((String)"Route 1 failed - 541ad1d6-0fc2-44d2-8b98-b8d71b9a5f66"));
        CompositeRoutingException ex = (CompositeRoutingException)deserializedError.getCause();
        MatcherAssert.assertThat((Object)((Error)ex.getErrors().get(0)).getErrorType().toString(), (Matcher)CoreMatchers.equalTo((Object)"CUSTOM:ROUTE0"));
        MatcherAssert.assertThat((Object)((Error)ex.getErrors().get(1)).getErrorType().toString(), (Matcher)CoreMatchers.equalTo((Object)"CUSTOM:ROUTE1"));
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/composite-routing-exception.xml";
    }

    @Test
    @Issue(value="W-16562974")
    public void testJavaCanSerializeAndDeserializeCompositeRouterException() throws Exception {
        this.flowRunner("compositeRoutingErrorFlow").run();
        Error error = (Error)this.queueManager.read("dlq", 5000L, TimeUnit.MILLISECONDS).getMessage().getPayload().getValue();
        byte[] errorSerialization = this.defaultSerializer.getInternalProtocol().serialize((Object)error);
        Error deserializedError = (Error)this.defaultSerializer.getInternalProtocol().deserialize(errorSerialization);
        this.verifyDeserializedError(deserializedError);
    }

    @Test
    @Issue(value="W-16562974")
    public void testJavaCanDeserializeCompositeRouterExceptionFromLegacyVersion() throws Exception {
        Error deserializedError;
        try (InputStream errorSerializationInputStream = this.getClass().getResourceAsStream(JAVA_FILENAME);){
            deserializedError = (Error)this.defaultSerializer.getInternalProtocol().deserialize(errorSerializationInputStream);
        }
        this.verifyDeserializedError(deserializedError);
    }
}

