/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.metrics;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.metrics.api.error.ErrorIdProvider;
import org.mule.runtime.metrics.api.error.ErrorMetrics;
import org.mule.runtime.metrics.api.meter.Meter;
import org.mule.runtime.metrics.impl.meter.error.DefaultErrorMetricsFactory;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.components.metrics.AbstractOpenTelemetryMetricsTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class OpenTelemetryErrorCountersTestCase
extends AbstractOpenTelemetryMetricsTestCase {
    private static final int TIMEOUT_MILLIS = 5000;
    private static final int POLL_DELAY_MILLIS = 100;
    private final String flowName;
    private final boolean shouldFail;
    private final int expectedErrorDataPoints;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"simple-flow", true, 1}, {"simple-propagate-flow", true, 1}, {"simple-continue-flow", false, 1}, {"failed-propagate-flow", true, 2}, {"failed-continue-flow", true, 2}, {"failed-try-propagate-flow", true, 2}, {"failed-try-continue-flow", false, 2}, {"failed-try-and-propagate-flow", true, 3}, {"failed-try-and-continue-flow", true, 3});
    }

    public OpenTelemetryErrorCountersTestCase(String flowName, boolean shouldFail, int expectedErrorDataPoints) {
        this.flowName = flowName;
        this.shouldFail = shouldFail;
        this.expectedErrorDataPoints = expectedErrorDataPoints;
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        builders.add(this.getRandomErrorIdErrorMetricsFactoryConfigurationBuilder());
    }

    private ConfigurationBuilder getRandomErrorIdErrorMetricsFactoryConfigurationBuilder() {
        return new ConfigurationBuilder(){

            public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
            }

            public void configure(MuleContext muleContext) throws ConfigurationException {
                muleContext.getCustomizationService().overrideDefaultServiceClass("_muleErrorMetricsFactory", RandomErrorIdErrorMetricsFactory.class);
            }
        };
    }

    @Test
    public void errorMetricsCount() throws Exception {
        FlowRunner flowRunner = (FlowRunner)this.flowRunner(this.flowName).withPayload((Object)"test");
        if (this.shouldFail) {
            flowRunner.runExpectingException();
        } else {
            flowRunner.run();
        }
        this.assertExportedDataPointsCount(this.expectedErrorDataPoints);
    }

    private void assertExportedDataPointsCount(int expected) {
        new PollingProber(5000L, 100L).check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                try {
                    OpenTelemetryErrorCountersTestCase.this.verifyMetricsExists("error-count", "Mule runtime error count", "OpenTelemetryErrorCountersTestCase#errorMetricsCount[" + OpenTelemetryErrorCountersTestCase.this.flowName + "]", "Mule runtime error metrics", OpenTelemetryErrorCountersTestCase.this.expectedErrorDataPoints, OpenTelemetryErrorCountersTestCase.this.server.getMetrics());
                }
                catch (Throwable e) {
                    return false;
                }
                return true;
            }

            public String describeFailure() {
                return "Expected data points where not exported. Check the test log for non matching exported metrics.";
            }
        });
    }

    protected String getConfigFile() {
        return "metrics/error-counters-metric.xml";
    }

    private static class RandomErrorIdErrorMetricsFactory
    extends DefaultErrorMetricsFactory {
        private RandomErrorIdErrorMetricsFactory() {
        }

        public ErrorMetrics create(Meter errorMetricsMeter) {
            return this.create(errorMetricsMeter, new ErrorIdProvider(){

                public String getErrorId(Error error) {
                    return UUID.randomUUID().toString();
                }

                public String getErrorId(Throwable error) {
                    return UUID.randomUUID().toString();
                }
            });
        }
    }
}

