/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components.metrics.export;

import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import java.util.ArrayList;
import java.util.List;
import org.mule.test.components.metrics.export.ExportedMeter;

public class OpenTelemetryMetricsTestUtils {
    public static final String SERVICE_NAME_KEY = "service.name";

    public static List<ExportedMeter> getMetrics(ExportMetricsServiceRequest request) {
        ArrayList<ExportedMeter> exportedMeters = new ArrayList<ExportedMeter>();
        for (ResourceMetrics resourceMetrics : request.getResourceMetricsList()) {
            List attributeKeyValues = resourceMetrics.getResource().getAttributesList();
            for (ScopeMetrics scopeMetrics : resourceMetrics.getScopeMetricsList()) {
                for (Metric metrics : scopeMetrics.getMetricsList()) {
                    ExportedMeter exportedMeter = new ExportedMeter();
                    OpenTelemetryMetricsTestUtils.addResourceName(exportedMeter, attributeKeyValues);
                    exportedMeter.setDescription(metrics.getDescription());
                    exportedMeter.setInstrumentName(scopeMetrics.getScope().getName());
                    exportedMeter.setName(metrics.getName());
                    exportedMeter.setValue(metrics.getSum().getDataPoints(0).getAsInt());
                    exportedMeters.add(exportedMeter);
                }
            }
        }
        return exportedMeters;
    }

    private static void addResourceName(ExportedMeter exportedMeter, List<KeyValue> attributeKeyValues) {
        for (KeyValue attributeKeyValue : attributeKeyValues) {
            if (!attributeKeyValue.getKey().equals(SERVICE_NAME_KEY)) continue;
            exportedMeter.setResourceName(attributeKeyValue.getValue().getStringValue());
        }
    }
}

