/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tck.testmodels.mule;

import org.mule.runtime.api.meta.NameableObject;

public final class ObjectUtils {

  public static String toString(Object obj) {
    return toString(obj, "");
  }

  public static String toString(Object obj, String defaultValue) {
    if (obj == null) {
      return defaultValue;
    }

    String str = obj.getClass().getName();
    if (obj instanceof NameableObject) {
      str += String.format(" '%s'", ((NameableObject) obj).getName());
    }
    return str;
  }

  private ObjectUtils() {
    // nothing to do
  }
}
