/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.mule.BenchmarkUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.api.source.MessageSource;
import org.mule.construct.Flow;
import org.mule.tck.TriggerableMessageSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class FlowOneWayBenchmark {
    public static final String TEST_PAYLOAD = "test";
    private MuleContext muleContext;
    private Flow flow;
    private TriggerableMessageSource source;
    @Param(value={"org.mule.processor.strategy.AsynchronousProcessingStrategy", "org.mule.processor.strategy.QueuedAsynchronousProcessingStrategy"})
    public String processingStrategyFactory;

    @Setup
    public void setup() throws Exception {
        this.muleContext = BenchmarkUtils.createMuleContext();
        this.muleContext.start();
        this.source = new TriggerableMessageSource();
        this.flow = new Flow("flow", this.muleContext);
        ArrayList processors = new ArrayList();
        this.flow.setMessageProcessors(Collections.singletonList(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) {
                return event;
            }
        }));
        this.flow.setMessageSource((MessageSource)this.source);
        this.flow.setProcessingStrategy((ProcessingStrategy)Class.forName(this.processingStrategyFactory).newInstance());
        this.muleContext.getRegistry().registerFlowConstruct((FlowConstruct)this.flow);
    }

    @TearDown
    public void teardown() {
        this.muleContext.dispose();
    }

    @Benchmark
    @Threads(value=1)
    public MuleEvent processSourceOneWay1Thread() throws MuleException {
        return this.source.trigger((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow));
    }

    @Benchmark
    @Threads(value=2)
    public MuleEvent processSourceOneWay2Threads() throws MuleException {
        return this.source.trigger((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow));
    }

    @Benchmark
    @Threads(value=4)
    public MuleEvent processSourceOneWay4Threads() throws MuleException {
        return this.source.trigger((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow));
    }

    @Benchmark
    @Threads(value=8)
    public MuleEvent processSourceOneWay8Threads() throws MuleException {
        return this.source.trigger((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow));
    }

    @Benchmark
    @Threads(value=16)
    public MuleEvent processSourceOneWay16Threads() throws MuleException {
        return this.source.trigger((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow));
    }

    @Benchmark
    @Threads(value=32)
    public MuleEvent processSourceOneWay32Threads() throws MuleException {
        return this.source.trigger((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow));
    }

    @Benchmark
    @Threads(value=64)
    public MuleEvent processSourceOneWay64Threads() throws MuleException {
        return this.source.trigger((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow));
    }

    @Benchmark
    @Threads(value=128)
    public MuleEvent processSourceOneWay128Threads() throws MuleException {
        return this.source.trigger((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow));
    }

    @Benchmark
    @Threads(value=256)
    public MuleEvent processSourceOneWay256Threads() throws MuleException {
        return this.source.trigger((MuleEvent)new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow));
    }
}

