/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el;

import java.util.concurrent.TimeUnit;
import org.mule.BenchmarkUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.construct.Flow;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class ExpressionBenchmark {
    public static final String TEST_PAYLOAD = "test";
    private MuleContext muleContext;
    private Flow flow;
    private MuleEvent event;

    @Setup
    public void setup() throws Exception {
        this.muleContext = BenchmarkUtils.createMuleContext();
        this.muleContext.start();
        this.flow = new Flow("flow", this.muleContext);
        this.muleContext.getRegistry().registerFlowConstruct((FlowConstruct)this.flow);
        this.event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)TEST_PAYLOAD, this.muleContext), MessageExchangePattern.ONE_WAY, (FlowConstruct)this.flow);
        this.event.setFlowVariable("foo", (Object)"bar");
    }

    @TearDown
    public void teardown() {
        this.muleContext.dispose();
    }

    @Benchmark
    public Object nullExpression() {
        return this.muleContext.getExpressionManager().evaluate("flowVars['dummy']", this.event);
    }

    @Benchmark
    public Object payloadExpression() {
        return this.muleContext.getExpressionManager().evaluate("payload", this.event);
    }

    @Benchmark
    public Object melFlowVars() {
        return this.muleContext.getExpressionManager().evaluate("flowVars['foo']=='bar'", this.event);
    }

    @Benchmark
    public Object dwFlowVars() {
        return this.muleContext.getExpressionManager().evaluate("variables.foo == 'bar'", this.event);
    }
}

