/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.mule.api.MuleRuntimeException;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Fork(value=1)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Warmup(iterations=5)
@Measurement(iterations=10)
public class SessionSignatureBenchmark {
    private static final Mac MAC_SIGNER;

    @Benchmark
    @Threads(value=1)
    public byte[] baselineSingleThread() {
        return this.generateRandomData(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    @Threads(value=1)
    public byte[] synchronizedSignSingleThread() {
        Class<SessionSignatureBenchmark> clazz = SessionSignatureBenchmark.class;
        synchronized (SessionSignatureBenchmark.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MAC_SIGNER.doFinal(this.generateRandomData(256));
        }
    }

    @Benchmark
    @Threads(value=1)
    public byte[] clonedSignerSingleThread() throws CloneNotSupportedException {
        return ((Mac)MAC_SIGNER.clone()).doFinal(this.generateRandomData(256));
    }

    @Benchmark
    public byte[] baseline() {
        return this.generateRandomData(256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    public byte[] synchronizedSign() {
        Class<SessionSignatureBenchmark> clazz = SessionSignatureBenchmark.class;
        synchronized (SessionSignatureBenchmark.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return MAC_SIGNER.doFinal(this.generateRandomData(256));
        }
    }

    @Benchmark
    public byte[] clonedSigner() throws CloneNotSupportedException {
        return ((Mac)MAC_SIGNER.clone()).doFinal(this.generateRandomData(256));
    }

    private byte[] generateRandomData(int length) {
        Blackhole.consumeCPU((long)40000000L);
        byte[] array = new byte[length];
        new Random().nextBytes(array);
        return array;
    }

    static {
        try {
            String algorithm = "HmacSHA256";
            MAC_SIGNER = Mac.getInstance(algorithm);
            SecretKeySpec secretKeySpec = new SecretKeySpec("ThoughtYouHeardFootstepsBehind".getBytes(StandardCharsets.UTF_8), algorithm);
            MAC_SIGNER.init(secretKeySpec);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

