/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.tck.TriggerableMessageSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import reactor.core.publisher.Mono;

@Warmup(iterations=10)
@Measurement(iterations=10)
public class FlowBenchmark
extends AbstractBenchmark {
    public static final String TEST_PAYLOAD = "test";
    public static final String TEST_CONNECTOR = "test";
    private MuleContext muleContext;
    private Flow flow;
    private TriggerableMessageSource source;
    @Param(value={"org.mule.runtime.core.processor.strategy.LegacySynchronousProcessingStrategyFactory", "org.mule.runtime.core.processor.strategy.SynchronousStreamProcessingStrategyFactory", "org.mule.runtime.core.processor.strategy.SynchronousProcessingStrategyFactory", "org.mule.runtime.core.processor.strategy.ReactorProcessingStrategyFactory", "org.mule.runtime.core.processor.strategy.ProactorProcessingStrategyFactory", "org.mule.runtime.core.processor.strategy.WorkQueueProcessingStrategyFactory"})
    public String processingStrategyFactory;

    @Setup
    public void setup() throws Exception {
        this.muleContext = this.createMuleContextWithServices();
        this.muleContext.start();
        this.source = new TriggerableMessageSource();
        this.flow = Flow.builder((String)"flow", (MuleContext)this.muleContext).messageProcessors(Collections.singletonList(event -> event)).messageSource((MessageSource)this.source).processingStrategyFactory((ProcessingStrategyFactory)Class.forName(this.processingStrategyFactory).newInstance()).build();
        this.muleContext.getRegistry().registerFlowConstruct((FlowConstruct)this.flow);
    }

    @TearDown
    public void teardown() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.muleContext.getRegistry().lookupObject(SchedulerService.class));
        this.muleContext.dispose();
    }

    @Benchmark
    public Event processSource() throws MuleException {
        return this.source.trigger(Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flow, (String)"test")).message((Message)InternalMessage.of((Object)"test")).build());
    }

    @Benchmark
    public CountDownLatch processSourceStream() throws MuleException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1000);
        for (int i = 0; i < 1000; ++i) {
            Mono.just((Object)Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flow, (String)"test")).message((Message)InternalMessage.of((Object)"test")).build()).transform((Function)this.source.getListener()).doOnNext(event -> latch.countDown()).subscribe();
        }
        latch.await();
        return latch;
    }

    @Benchmark
    public Event processFlow() throws MuleException {
        return this.flow.process(Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flow, (String)"test")).message((Message)InternalMessage.of((Object)"test")).build());
    }

    @Benchmark
    public CountDownLatch processFlowStream() throws MuleException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1000);
        for (int i = 0; i < 1000; ++i) {
            Mono.just((Object)Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)this.flow, (String)"test")).message((Message)InternalMessage.of((Object)"test")).build()).transform((Function)this.flow).doOnNext(event -> latch.countDown()).subscribe();
        }
        latch.await();
        return latch;
    }
}

