/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.config.builders.BasicRuntimeServicesConfigurationBuilder;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.DefaultsConfigurationBuilder;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.DefaultMuleContextFactory;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fork(value=1)
@Threads(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
public class AbstractBenchmark {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBenchmark.class);
    public static final String CONNECTOR_NAME = "test";
    public static final String FLOW_NAME = "flow";
    public static final String PAYLOAD;
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final ComponentLocation CONNECTOR_LOCATION;

    public MuleContext createMuleContext() throws MuleException {
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        return muleContextFactory.createMuleContext();
    }

    public MuleContext createMuleContextWithServices() throws MuleException {
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        ArrayList<Object> builderList = new ArrayList<Object>();
        builderList.add(new BasicRuntimeServicesConfigurationBuilder());
        builderList.add(new DefaultsConfigurationBuilder());
        return muleContextFactory.createMuleContext(builderList.toArray(new ConfigurationBuilder[0]));
    }

    public Flow createFlow(MuleContext muleContext) {
        return Flow.builder((String)FLOW_NAME, (MuleContext)muleContext).build();
    }

    public Event createEvent(Flow flow) {
        return this.createEvent(flow, PAYLOAD);
    }

    public Event createEvent(Flow flow, Object payload) {
        try {
            return Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flow, (ComponentLocation)CONNECTOR_LOCATION)).message(Message.of((Object)payload)).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        CONNECTOR_LOCATION = DefaultComponentLocation.fromSingleComponent((String)CONNECTOR_NAME);
        try {
            PAYLOAD = IOUtils.getResourceAsString((String)"test-data.json", AbstractBenchmark.class);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

