/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.policy;

import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.policy.DefaultPolicyStateHandler;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Threads;

public class DefaultPolicyStateHandlerBenchmark
extends AbstractBenchmark {
    private final PolicyStateHandler handler = new DefaultPolicyStateHandler();
    private static final Processor DUMMY_PROCESSOR = event -> event;

    @Benchmark
    @Threads(value=32)
    public Pair<Processor, Optional<CoreEvent>> source() {
        CoreEvent event = CoreEvent.builder((EventContext)EventContextFactory.create((String)("" + Math.random()), (String)"", (ComponentLocation)CONNECTOR_LOCATION, (FlowExceptionHandler)NullExceptionHandler.getInstance())).message(Message.of((Object)PAYLOAD)).build();
        PolicyStateId policyStateId = new PolicyStateId(event.getContext().getCorrelationId(), "myPolicy");
        this.handler.updateState(policyStateId, event);
        Optional latestState = this.handler.getLatestState(policyStateId);
        ((BaseEventContext)event.getContext()).success();
        return Pair.of((Object)DUMMY_PROCESSOR, (Object)latestState);
    }

    @Benchmark
    @Threads(value=32)
    public Pair<Processor, Optional<CoreEvent>> operation() {
        CoreEvent event = CoreEvent.builder((EventContext)EventContextFactory.create((String)("" + Math.random()), (String)"", (ComponentLocation)CONNECTOR_LOCATION, (FlowExceptionHandler)NullExceptionHandler.getInstance())).message(Message.of((Object)PAYLOAD)).build();
        PolicyStateId policyStateId = new PolicyStateId(event.getContext().getCorrelationId(), "myPolicy");
        Optional latestState = this.handler.getLatestState(policyStateId);
        this.handler.updateState(policyStateId, latestState.orElse(event));
        latestState = this.handler.getLatestState(policyStateId);
        this.handler.updateState(policyStateId, event);
        this.handler.updateState(policyStateId, event);
        ((BaseEventContext)event.getContext()).success();
        return Pair.of((Object)DUMMY_PROCESSOR, (Object)latestState);
    }
}

