/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.mule.AbstractBenchmark;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.simple.ObjectToString;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.OutputTimeUnit;

@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ObjectToStringBenchmark
extends AbstractBenchmark {
    private static final Charset charset = Charset.defaultCharset();
    private ObjectToString objectToString = new ObjectToString();
    private InputStream inputStream = new StringBufferInputStream(RandomStringUtils.random((int)0x1400000));

    @Benchmark
    public Object inputStreamToString() throws TransformerException {
        return this.objectToString.doTransform((Object)this.inputStream, charset);
    }

    @Benchmark
    public Object inputStreamToStringIoUtilsToString() throws TransformerException, IOException {
        return IOUtils.toString((InputStream)this.inputStream);
    }

    @Benchmark
    public Object inputStreamToStringIOUtilsCopyOutputStream() throws TransformerException, IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)this.inputStream, (OutputStream)byteOut);
        return byteOut.toString(charset.name());
    }

    @Benchmark
    public Object inputStreamToStringIOUtilsCopyWriter() throws TransformerException, IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)this.inputStream, (Writer)writer, (Charset)charset);
        return writer.toString();
    }
}

