/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.extension.api.client.OperationParameterizer;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.manager.DefaultExtensionManagerFactory;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.runtime.client.DefaultExtensionsClient;
import org.mule.runtime.module.extension.internal.runtime.client.DefaultExtensionsClientTestExtension;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=0)
@Measurement(iterations=1)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class DefaultExtensionsClientBenchmark
extends AbstractBenchmark {
    private MuleContext muleContext;
    private DefaultExtensionsClient extensionsClient;

    @Setup
    public void setup() throws MuleException {
        this.muleContext = this.createMuleContextWithServices();
        this.muleContext.start();
        this.extensionsClient = new DefaultExtensionsClient();
        this.muleContext.getInjector().inject((Object)this.extensionsClient);
        this.extensionsClient.initialise();
    }

    @TearDown
    public void tearDown() {
        this.extensionsClient.dispose();
        this.muleContext.dispose();
    }

    @Benchmark
    public Result<?, ?> basicNoOp() {
        return this.execute("basicNoOp");
    }

    @Benchmark
    public Result<?, ?> multipleParametersNoOp() {
        return this.execute("multipleParametersNoOp", parameterizer -> {
            parameterizer.withParameter("stringParameter", (Object)"Hey");
            parameterizer.withParameter("intParameter", (Object)9);
            parameterizer.withParameter("strings", Arrays.asList("a", "b", "c"));
        });
    }

    @Benchmark
    public Result<?, ?> simplePayloadOutput() {
        return this.execute("simplePayloadOutput");
    }

    @Benchmark
    public Result<?, ?> simpleResultOutput() {
        return this.execute("simpleResultOutput");
    }

    @Benchmark
    public Result<?, ?> simpleIdentity() {
        return this.execute("simpleIdentity", parameterizer -> parameterizer.withParameter("content", (Object)new ByteArrayInputStream("Some payload".getBytes())));
    }

    @Override
    protected List<ConfigurationBuilder> getAdditionalConfigurationBuilders() {
        return Collections.singletonList(new ExtensionManagerConfigurationBuilder());
    }

    private Result<?, ?> execute(String operationName) {
        return this.execute(operationName, operationParameterizer -> {});
    }

    private Result<?, ?> execute(String operationName, Consumer<OperationParameterizer> parameterizerConsumer) {
        try {
            return (Result)this.extensionsClient.execute("Default Extensions Client Test", operationName, parameterizerConsumer).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static ExtensionModel loadTestExtensionModel() {
        ExtensionModelLoadingRequest loadingRequest = ExtensionModelLoadingRequest.builder((ClassLoader)Thread.currentThread().getContextClassLoader(), (DslResolvingContext)DslResolvingContext.getDefault(Collections.emptySet())).addParameter("type", (Object)DefaultExtensionsClientTestExtension.class.getName()).addParameter("version", (Object)"1.0.0-SNAPSHOT").build();
        return new DefaultJavaExtensionModelLoader().loadExtensionModel(loadingRequest);
    }

    private static class ExtensionManagerConfigurationBuilder
    extends AbstractConfigurationBuilder {
        private ExtensionManagerConfigurationBuilder() {
        }

        protected void doConfigure(MuleContext muleContext) throws RegistrationException {
            ExtensionManager extensionManager = new DefaultExtensionManagerFactory().create(muleContext);
            extensionManager.registerExtension(DefaultExtensionsClientBenchmark.loadTestExtensionModel());
            MuleRegistry registry = ((MuleContextWithRegistry)muleContext).getRegistry();
            registry.registerObject("_muleExtensionManager", (Object)extensionManager);
        }
    }
}

