/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.AbstractBenchmark;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.registry.LegacyRegistryUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Warmup(iterations=20)
@Measurement(iterations=100)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class EventContextBenchmark
extends AbstractBenchmark {
    private MuleContext muleContext;
    private Flow flow;
    private final String id = UUID.getUUID();
    private final String severId = UUID.getUUID();
    private CoreEvent event;

    @Setup
    public void setup() throws Exception {
        this.muleContext = this.createMuleContextWithServices();
        this.muleContext.start();
        this.flow = this.createFlow(this.muleContext);
        LegacyRegistryUtils.registerObject((MuleContext)this.muleContext, (String)"flow", (Object)this.flow);
        Message.Builder messageBuilder = Message.builder().value((Object)PAYLOAD);
        CoreEvent.Builder eventBuilder = CoreEvent.builder((EventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION)).message(messageBuilder.build());
        this.event = eventBuilder.build();
    }

    @TearDown
    public void teardown() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)LegacyRegistryUtils.lookupObject((MuleContext)this.muleContext, SchedulerService.class));
        this.muleContext.dispose();
    }

    @Benchmark
    public EventContext createEventContext() {
        return EventContextFactory.create((String)this.id, (String)this.severId, (ComponentLocation)CONNECTOR_LOCATION, null, Optional.empty());
    }

    @Benchmark
    public EventContext createEventContextWithFlow() {
        return EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION);
    }

    @Benchmark
    public Object[] createEventContextWithFlowAndComplete() {
        AtomicReference result = new AtomicReference();
        AtomicBoolean complete = new AtomicBoolean();
        BaseEventContext eventContext = (BaseEventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION);
        Mono.from((Publisher)Mono.from((Publisher)eventContext.getResponsePublisher())).doOnSuccess(response -> result.set(response)).subscribe();
        eventContext.onTerminated((response, throwable) -> complete.set(true));
        eventContext.success(this.event);
        return new Object[]{result, complete};
    }

    @Benchmark
    public Object[] createEventContextWithFlowAndCompleteWithExternalCompletion() {
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        AtomicReference result = new AtomicReference();
        AtomicBoolean complete = new AtomicBoolean();
        BaseEventContext eventContext = (BaseEventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION, null, Optional.of(completableFuture));
        Mono.from((Publisher)Mono.from((Publisher)eventContext.getResponsePublisher())).doOnSuccess(response -> result.set(response)).subscribe();
        eventContext.onTerminated((response, throwable) -> complete.set(true));
        eventContext.success(this.event);
        completableFuture.complete(null);
        return new Object[]{result, complete};
    }

    @Benchmark
    public Object[] createEventContextWith10ChildrenTerminateAllAtOnce() {
        return this.createEventContextTerminateAllAtOnce(10);
    }

    @Benchmark
    public Object[] createEventContextWith1000ChildrenTerminateAllAtOnce() {
        return this.createEventContextTerminateAllAtOnce(1000);
    }

    private Object[] createEventContextTerminateAllAtOnce(int childrenCount) {
        AtomicReference result = new AtomicReference();
        AtomicBoolean complete = new AtomicBoolean();
        BaseEventContext eventContext = (BaseEventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION);
        ArrayList<BaseEventContext> children = new ArrayList<BaseEventContext>(childrenCount);
        for (int i = 0; i < childrenCount; ++i) {
            children.add(DefaultEventContext.child((BaseEventContext)eventContext, Optional.empty()));
        }
        Mono.from((Publisher)Mono.from((Publisher)eventContext.getResponsePublisher())).doOnSuccess(response -> result.set(response)).subscribe();
        eventContext.onTerminated((response, throwable) -> complete.set(true));
        eventContext.success(this.event);
        for (BaseEventContext child : children) {
            child.success();
        }
        return new Object[]{result, complete};
    }

    @Benchmark
    public Object[] createEventContextWith10ChildrenForEach() {
        return this.childEventContextForEach(10);
    }

    @Benchmark
    public Object[] createEventContextWith1000ChildrenForEach() {
        return this.childEventContextForEach(1000);
    }

    private Object[] childEventContextForEach(int childrenCount) {
        AtomicReference result = new AtomicReference();
        AtomicBoolean complete = new AtomicBoolean();
        BaseEventContext eventContext = (BaseEventContext)EventContextFactory.create((FlowConstruct)this.flow, (ComponentLocation)CONNECTOR_LOCATION);
        for (int i = 0; i < childrenCount; ++i) {
            BaseEventContext child = DefaultEventContext.child((BaseEventContext)eventContext, Optional.empty());
            child.success();
        }
        Mono.from((Publisher)Mono.from((Publisher)eventContext.getResponsePublisher())).doOnSuccess(response -> result.set(response)).subscribe();
        eventContext.onTerminated((response, throwable) -> complete.set(true));
        eventContext.success(this.event);
        return new Object[]{result, complete};
    }
}

