/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.filter.PatternInclusionsDependencyFilter;
import org.eclipse.aether.util.graph.visitor.PathRecordingDependencyVisitor;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RepositorySystem system;
    private RepositorySystemSession session;
    private List<RemoteRepository> remoteRepositories;

    public DependencyResolver(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remoteRepositories) {
        Preconditions.checkNotNull((Object)system, (String)"system cannot be null");
        Preconditions.checkNotNull((Object)session, (String)"session cannot be null");
        this.system = system;
        this.session = session;
        this.remoteRepositories = remoteRepositories;
    }

    public ArtifactDescriptorResult readArtifactDescriptor(Artifact artifact) throws ArtifactDescriptorException {
        Preconditions.checkNotNull((Object)artifact, (String)"artifact cannot be null");
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(artifact, this.remoteRepositories, null);
        return this.system.readArtifactDescriptor(this.session, request);
    }

    public ArtifactResult resolveArtifact(Artifact artifact) throws ArtifactResolutionException {
        Preconditions.checkNotNull((Object)artifact, (String)"artifact cannot be null");
        ArtifactRequest request = new ArtifactRequest(artifact, this.remoteRepositories, null);
        return this.system.resolveArtifact(this.session, request);
    }

    public List<Dependency> getDirectDependencies(Artifact artifact) throws ArtifactDescriptorException {
        Preconditions.checkNotNull((Object)artifact, (String)"artifact cannot be null");
        return this.readArtifactDescriptor(artifact).getDependencies();
    }

    public List<File> resolveDependencies(Dependency root, List<Dependency> directDependencies, List<Dependency> managedDependencies, DependencyFilter dependencyFilter) throws DependencyCollectionException, DependencyResolutionException {
        DependencyNode node;
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(root);
        collectRequest.setDependencies(directDependencies);
        collectRequest.setManagedDependencies(managedDependencies);
        collectRequest.setRepositories(this.remoteRepositories);
        try {
            node = this.system.collectDependencies(this.session, collectRequest).getRoot();
            this.logDependencyGraph(node, collectRequest);
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            dependencyRequest.setCollectRequest(collectRequest);
            if (dependencyFilter != null) {
                dependencyRequest.setFilter(dependencyFilter);
            }
            node = this.system.resolveDependencies(this.session, dependencyRequest).getRoot();
        }
        catch (DependencyResolutionException e) {
            this.logger.warn("Dependencies couldn't be resolved for request '{}', {}", (Object)collectRequest, (Object)e.getMessage());
            DependencyNode node2 = e.getResult().getRoot();
            this.logUnresolvedArtifacts(node2, e);
            throw e;
        }
        List<File> files = this.getFiles(node);
        return files;
    }

    private void logDependencyGraph(DependencyNode node, Object request) {
        if (this.logger.isTraceEnabled()) {
            PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor(null, false);
            node.accept((DependencyVisitor)visitor);
            this.logger.trace("******* Dependency Graph calculated for {} with request: '{}' *******", (Object)request.getClass().getSimpleName(), request);
            visitor.getPaths().stream().forEach(pathList -> this.logger.trace(Joiner.on((String)" -> ").join((Iterable)pathList.stream().filter(path -> path != null).collect(Collectors.toList()))));
            this.logger.trace("******* End of dependency Graph *******");
        }
    }

    private List<File> getFiles(DependencyNode node) {
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        node.accept((DependencyVisitor)nlg);
        return nlg.getFiles().stream().map(File::getAbsoluteFile).collect(Collectors.toList());
    }

    private void logUnresolvedArtifacts(DependencyNode node, DependencyResolutionException e) {
        List artifactResults = e.getResult().getArtifactResults().stream().filter(artifactResult -> !artifactResult.getExceptions().isEmpty()).collect(Collectors.toList());
        List patternInclusion = artifactResults.stream().map(artifactResult -> ArtifactIdUtils.toId((Artifact)artifactResult.getRequest().getArtifact())).collect(Collectors.toList());
        PathRecordingDependencyVisitor visitor = new PathRecordingDependencyVisitor((DependencyFilter)new PatternInclusionsDependencyFilter(patternInclusion), node.getArtifact() != null);
        node.accept((DependencyVisitor)visitor);
        visitor.getPaths().stream().forEach(path -> {
            List unresolvedArtifactPath = path.stream().filter(dependencyNode -> dependencyNode.getArtifact() != null).collect(Collectors.toList());
            if (!unresolvedArtifactPath.isEmpty()) {
                this.logger.warn("Dependency path to not resolved artifacts -> {}", (Object)unresolvedArtifactPath.toString());
            }
        });
    }
}

