/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.ContainerClassLoaderFilterFactory;
import org.mule.runtime.container.internal.ContainerModuleDiscoverer;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFilterFactory;
import org.mule.runtime.module.artifact.classloader.ClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.ClassLoaderFilterFactory;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.util.FileJarExplorer;
import org.mule.runtime.module.artifact.util.JarInfo;
import org.mule.test.runner.api.ArtifactClassLoaderHolder;
import org.mule.test.runner.api.ArtifactUrlClassification;
import org.mule.test.runner.api.ArtifactsUrlClassification;
import org.mule.test.runner.api.PluginUrlClassification;
import org.mule.test.runner.classloader.PluginLookPolicyFactory;
import org.mule.test.runner.classloader.TestArtifactClassLoaderFilter;
import org.mule.test.runner.classloader.TestContainerClassLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedClassLoaderFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClassLoaderFilterFactory classLoaderFilterFactory = new ArtifactClassLoaderFilterFactory();
    private PluginLookPolicyFactory pluginLookupPolicyGenerator = new PluginLookPolicyFactory();

    public ArtifactClassLoaderHolder createArtifactClassLoader(List<String> extraBootPackages, ArtifactsUrlClassification artifactsUrlClassification) {
        ClassLoaderLookupPolicy childClassLoaderLookupPolicy;
        ArtifactClassLoader containerClassLoader;
        DefaultModuleRepository moduleRepository = new DefaultModuleRepository((ModuleDiscoverer)new ContainerModuleDiscoverer(ContainerClassLoaderFactory.class.getClassLoader()));
        try (TestContainerClassLoaderFactory testContainerClassLoaderFactory = new TestContainerClassLoaderFactory(extraBootPackages, artifactsUrlClassification.getContainerUrls().toArray(new URL[0]), moduleRepository);){
            containerClassLoader = this.createContainerArtifactClassLoader(testContainerClassLoaderFactory, artifactsUrlClassification);
            childClassLoaderLookupPolicy = testContainerClassLoaderFactory.getContainerClassLoaderLookupPolicy(containerClassLoader.getClassLoader());
        }
        List<ArtifactClassLoader> serviceArtifactClassLoaders = this.createServiceClassLoaders(containerClassLoader.getClassLoader(), childClassLoaderLookupPolicy, artifactsUrlClassification);
        RegionClassLoader regionClassLoader = new RegionClassLoader("Region", new ArtifactDescriptor("Region"), containerClassLoader.getClassLoader(), childClassLoaderLookupPolicy);
        ArrayList<FilteringArtifactClassLoader> filteredPluginsArtifactClassLoaders = new ArrayList<FilteringArtifactClassLoader>();
        ArrayList<ArtifactClassLoader> pluginsArtifactClassLoaders = new ArrayList<ArtifactClassLoader>();
        ArrayList<ArtifactClassLoaderFilter> pluginArtifactClassLoaderFilters = new ArrayList<ArtifactClassLoaderFilter>();
        if (!artifactsUrlClassification.getPluginUrlClassifications().isEmpty()) {
            for (PluginUrlClassification pluginUrlClassification : artifactsUrlClassification.getPluginUrlClassifications()) {
                this.logClassLoaderUrls("PLUGIN (" + pluginUrlClassification.getName() + ")", pluginUrlClassification.getUrls());
                String artifactId = AbstractArtifactClassLoaderBuilder.getArtifactPluginId((String)regionClassLoader.getArtifactId(), (String)pluginUrlClassification.getName());
                MuleArtifactClassLoader pluginCL = new MuleArtifactClassLoader(artifactId, new ArtifactDescriptor(pluginUrlClassification.getName()), pluginUrlClassification.getUrls().toArray(new URL[0]), (ClassLoader)regionClassLoader, this.pluginLookupPolicyGenerator.createLookupPolicy(pluginUrlClassification, artifactsUrlClassification.getPluginUrlClassifications(), childClassLoaderLookupPolicy));
                pluginsArtifactClassLoaders.add((ArtifactClassLoader)pluginCL);
                ArtifactClassLoaderFilter filter = this.createArtifactClassLoaderFilter(pluginUrlClassification);
                pluginArtifactClassLoaderFilters.add(filter);
                filteredPluginsArtifactClassLoaders.add(new FilteringArtifactClassLoader((ArtifactClassLoader)pluginCL, (ClassLoaderFilter)filter));
            }
        }
        HashMap pluginsLookupStrategies = new HashMap();
        for (int i = 0; i < filteredPluginsArtifactClassLoaders.size(); ++i) {
            ArtifactClassLoaderFilter classLoaderFilter = (ArtifactClassLoaderFilter)pluginArtifactClassLoaderFilters.get(i);
            classLoaderFilter.getExportedClassPackages().forEach(p -> pluginsLookupStrategies.put(p, ParentFirstLookupStrategy.PARENT_FIRST));
        }
        ClassLoaderLookupPolicy appLookupPolicy = childClassLoaderLookupPolicy.extend(pluginsLookupStrategies);
        ArtifactClassLoader appClassLoader = this.createApplicationArtifactClassLoader((ClassLoader)regionClassLoader, appLookupPolicy, artifactsUrlClassification);
        JarInfo testJarInfo = this.getJarInfo(artifactsUrlClassification);
        regionClassLoader.addClassLoader(appClassLoader, (ArtifactClassLoaderFilter)new DefaultArtifactClassLoaderFilter(testJarInfo.getPackages(), testJarInfo.getResources()));
        for (int i = 0; i < filteredPluginsArtifactClassLoaders.size(); ++i) {
            ArtifactClassLoaderFilter classLoaderFilter = (ArtifactClassLoaderFilter)pluginArtifactClassLoaderFilters.get(i);
            regionClassLoader.addClassLoader((ArtifactClassLoader)filteredPluginsArtifactClassLoaders.get(i), classLoaderFilter);
        }
        return new ArtifactClassLoaderHolder(containerClassLoader, serviceArtifactClassLoaders, pluginsArtifactClassLoaders, appClassLoader);
    }

    protected List<ArtifactClassLoader> createServiceClassLoaders(ClassLoader parent, ClassLoaderLookupPolicy childClassLoaderLookupPolicy, ArtifactsUrlClassification artifactsUrlClassification) {
        ArrayList servicesArtifactClassLoaders = Lists.newArrayList();
        for (ArtifactUrlClassification serviceUrlClassification : artifactsUrlClassification.getServiceUrlClassifications()) {
            this.logClassLoaderUrls("SERVICE (" + serviceUrlClassification.getArtifactId() + ")", serviceUrlClassification.getUrls());
            MuleArtifactClassLoader artifactClassLoader = new MuleArtifactClassLoader(serviceUrlClassification.getName(), new ArtifactDescriptor(serviceUrlClassification.getName()), serviceUrlClassification.getUrls().toArray(new URL[0]), parent, childClassLoaderLookupPolicy);
            servicesArtifactClassLoaders.add(artifactClassLoader);
        }
        return servicesArtifactClassLoaders;
    }

    private JarInfo getJarInfo(ArtifactsUrlClassification artifactsUrlClassification) {
        HashSet packages = new HashSet();
        HashSet resources = new HashSet();
        FileJarExplorer jarExplorer = new FileJarExplorer();
        ArrayList libraries = Lists.newArrayList((Object[])new URL[]{artifactsUrlClassification.getApplicationUrls().get(0)});
        libraries.addAll(artifactsUrlClassification.getPluginSharedLibUrls());
        for (URL library : libraries) {
            JarInfo jarInfo = jarExplorer.explore(library);
            packages.addAll(jarInfo.getPackages());
            resources.addAll(jarInfo.getResources());
        }
        return new JarInfo(packages, resources);
    }

    protected ArtifactClassLoader createContainerArtifactClassLoader(TestContainerClassLoaderFactory testContainerClassLoaderFactory, ArtifactsUrlClassification artifactsUrlClassification) {
        MuleArtifactClassLoader launcherArtifact = this.createLauncherArtifactClassLoader();
        List muleModules = Collections.emptyList();
        ClassLoaderFilter filteredClassLoaderLauncher = new ContainerClassLoaderFilterFactory().create(testContainerClassLoaderFactory.getBootPackages(), muleModules);
        this.logClassLoaderUrls("CONTAINER", artifactsUrlClassification.getContainerUrls());
        return testContainerClassLoaderFactory.createContainerClassLoader((ClassLoader)new FilteringArtifactClassLoader((ArtifactClassLoader)launcherArtifact, filteredClassLoaderLauncher));
    }

    protected MuleArtifactClassLoader createLauncherArtifactClassLoader() {
        ClassLoader launcherClassLoader = IsolatedClassLoaderFactory.class.getClassLoader();
        return new MuleArtifactClassLoader("launcher", new ArtifactDescriptor("launcher"), new URL[0], launcherClassLoader, (ClassLoaderLookupPolicy)new MuleClassLoaderLookupPolicy(Collections.emptyMap(), Collections.emptySet())){

            public URL findResource(String name) {
                URL url = super.findResource(name);
                if (url == null && this.getParent() != null) {
                    url = this.getParent().getResource(name);
                }
                return url;
            }
        };
    }

    private ArtifactClassLoaderFilter createArtifactClassLoaderFilter(PluginUrlClassification pluginUrlClassification) {
        String exportedPackages = pluginUrlClassification.getExportedPackages().stream().collect(Collectors.joining(", "));
        String exportedResources = pluginUrlClassification.getExportedResources().stream().collect(Collectors.joining(", "));
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.classLoaderFilterFactory.create(exportedPackages, exportedResources);
        if (!pluginUrlClassification.getExportClasses().isEmpty()) {
            artifactClassLoaderFilter = new TestArtifactClassLoaderFilter(artifactClassLoaderFilter, pluginUrlClassification.getExportClasses());
        }
        return artifactClassLoaderFilter;
    }

    protected ArtifactClassLoader createApplicationArtifactClassLoader(ClassLoader parent, ClassLoaderLookupPolicy childClassLoaderLookupPolicy, ArtifactsUrlClassification artifactsUrlClassification) {
        this.logClassLoaderUrls("APP", artifactsUrlClassification.getApplicationUrls());
        return new MuleArtifactClassLoader("app", new ArtifactDescriptor("app"), artifactsUrlClassification.getApplicationUrls().toArray(new URL[0]), parent, childClassLoaderLookupPolicy);
    }

    protected void logClassLoaderUrls(String classLoaderName, List<URL> urls) {
        StringBuilder builder = new StringBuilder(classLoaderName).append(" classloader urls: [");
        urls.stream().forEach(e -> builder.append("\n").append(" ").append(e));
        builder.append("\n]");
        this.logClassLoadingTrace(builder.toString());
    }

    private void logClassLoadingTrace(String message) {
        if (this.isVerboseClassLoading().booleanValue()) {
            this.logger.info(message);
        } else {
            this.logger.debug(message);
        }
    }

    private Boolean isVerboseClassLoading() {
        return Boolean.valueOf(System.getProperty("mule.classloading.verbose"));
    }
}

