/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import java.util.HashMap;
import java.util.List;
import org.mule.runtime.module.artifact.classloader.ChildOnlyLookupStrategy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.test.runner.api.PluginUrlClassification;

public class PluginLookPolicyFactory {
    public ClassLoaderLookupPolicy createLookupPolicy(PluginUrlClassification pluginClassification, List<PluginUrlClassification> pluginClassifications, ClassLoaderLookupPolicy parentLookupPolicies) {
        HashMap<String, LookupStrategy> pluginsLookupPolicies = new HashMap<String, LookupStrategy>();
        for (PluginUrlClassification dependencyPluginClassification : pluginClassifications) {
            if (dependencyPluginClassification.getArtifactId().equals(pluginClassification.getArtifactId())) continue;
            LookupStrategy lookUpPolicyStrategy = this.getClassLoaderLookupStrategy(pluginClassification, dependencyPluginClassification);
            for (String exportedPackage : dependencyPluginClassification.getExportedPackages()) {
                pluginsLookupPolicies.put(exportedPackage, lookUpPolicyStrategy);
            }
        }
        return parentLookupPolicies.extend(pluginsLookupPolicies);
    }

    private LookupStrategy getClassLoaderLookupStrategy(PluginUrlClassification currentPluginClassification, PluginUrlClassification dependencyPluginClassification) {
        LookupStrategy parentFirst = currentPluginClassification.getPluginDependencies().contains(dependencyPluginClassification.getName()) ? ParentFirstLookupStrategy.PARENT_FIRST : ChildOnlyLookupStrategy.CHILD_ONLY;
        return parentFirst;
    }
}

