/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathClassifierContext {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Artifact rootArtifact;
    private final List<URL> classPathURLs;
    private final List<String> providedExclusions = Lists.newArrayList();
    private final List<String> testExclusions = Lists.newArrayList();
    private final List<String> testInclusions = Lists.newArrayList();
    private final List<String> extraBootPackages = Lists.newArrayList();
    private final List<String> sharedPluginLibCoordinates = Lists.newArrayList();
    private final List<Class> exportPluginClasses = Lists.newArrayList();
    private final List<String> excludedArtifacts = Lists.newArrayList();
    private final List<URL> applicationUrls = Lists.newArrayList();
    private boolean extensionMetadataGenerationEnabled = false;
    private File pluginResourcesFolder;

    public ClassPathClassifierContext(Artifact rootArtifact, File pluginResourcesFolder, List<URL> classPathURLs, List<String> excludedArtifacts, List<String> extraBootPackages, List<String> providedExclusions, List<String> testExclusions, List<String> testInclusions, List<String> sharedPluginLibCoordinates, List<Class> exportPluginClasses, List<URL> applicationUrls, boolean extensionMetadataGenerationEnabled) throws IOException {
        Preconditions.checkNotNull((Object)rootArtifact, (String)"rootArtifact cannot be null");
        Preconditions.checkNotNull(classPathURLs, (String)"classPathURLs cannot be null");
        this.rootArtifact = rootArtifact;
        this.pluginResourcesFolder = pluginResourcesFolder;
        this.classPathURLs = classPathURLs;
        this.excludedArtifacts.addAll(excludedArtifacts);
        this.extraBootPackages.addAll(extraBootPackages);
        this.providedExclusions.addAll(providedExclusions);
        this.testExclusions.addAll(testExclusions);
        this.testInclusions.addAll(testInclusions);
        this.sharedPluginLibCoordinates.addAll(sharedPluginLibCoordinates);
        this.exportPluginClasses.addAll(exportPluginClasses);
        this.applicationUrls.addAll(applicationUrls);
        this.extensionMetadataGenerationEnabled = extensionMetadataGenerationEnabled;
    }

    public Artifact getRootArtifact() {
        return this.rootArtifact;
    }

    public File getPluginResourcesFolder() {
        return this.pluginResourcesFolder;
    }

    public List<URL> getClassPathURLs() {
        return this.classPathURLs;
    }

    public List<String> getProvidedExclusions() {
        return this.providedExclusions;
    }

    public List<String> getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    public List<String> getTestExclusions() {
        return this.testExclusions;
    }

    public List<String> getTestInclusions() {
        return this.testInclusions;
    }

    public List<String> getExtraBootPackages() {
        return this.extraBootPackages;
    }

    public List<Class> getExportPluginClasses() {
        return this.exportPluginClasses;
    }

    public List<String> getSharedPluginLibCoordinates() {
        return this.sharedPluginLibCoordinates;
    }

    public List<URL> getApplicationUrls() {
        return this.applicationUrls;
    }

    public boolean isExtensionMetadataGenerationEnabled() {
        return this.extensionMetadataGenerationEnabled;
    }
}

