/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.mule.runtime.api.util.Preconditions;
import org.mule.test.runner.api.ArtifactClassLoaderHolder;
import org.mule.test.runner.api.ArtifactsUrlClassification;
import org.mule.test.runner.api.ClassPathClassifier;
import org.mule.test.runner.api.ClassPathClassifierContext;
import org.mule.test.runner.api.ClassPathUrlProvider;
import org.mule.test.runner.classloader.IsolatedClassLoaderFactory;
import org.mule.test.runner.maven.MavenModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactIsolatedClassLoaderBuilder {
    private static final String POM_XML = "pom.xml";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ClassPathClassifier classPathClassifier;
    private ClassPathUrlProvider classPathUrlProvider;
    private IsolatedClassLoaderFactory isolatedClassLoaderFactory = new IsolatedClassLoaderFactory();
    private Artifact rootArtifact;
    private File pluginResourcesFolder;
    private List<String> excludedArtifacts = Lists.newArrayList();
    private List<String> providedExclusions = Lists.newArrayList();
    private List<String> testExclusions = Lists.newArrayList();
    private List<String> testInclusions = Lists.newArrayList();
    private List<String> pluginCoordinates = Lists.newArrayList();
    private List<String> sharedPluginLibCoordinates = Lists.newArrayList();
    private List<Class> exportPluginClasses = Lists.newArrayList();
    private boolean extensionMetadataGenerationEnabled = false;
    private List<String> providedInclusions = Lists.newArrayList();
    private List<URL> applicationUrls = Lists.newArrayList();
    private List<String> extraBootPackages;

    public ArtifactIsolatedClassLoaderBuilder setPluginCoordinates(List<String> pluginCoordinates) {
        this.pluginCoordinates = pluginCoordinates;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setSharedPluginLibCoordinates(List<String> sharedPluginLibCoordinates) {
        this.sharedPluginLibCoordinates = sharedPluginLibCoordinates;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setClassPathClassifier(ClassPathClassifier classPathClassifier) {
        this.classPathClassifier = classPathClassifier;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setClassPathUrlProvider(ClassPathUrlProvider classPathUrlProvider) {
        this.classPathUrlProvider = classPathUrlProvider;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setRootArtifactClassesFolder(File rootArtifactClassesFolder) {
        this.rootArtifact = this.getRootArtifact(rootArtifactClassesFolder);
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setPluginResourcesFolder(File pluginResourcesFolder) {
        this.pluginResourcesFolder = pluginResourcesFolder;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExcludedArtifacts(List<String> excludedArtifacts) {
        this.excludedArtifacts = excludedArtifacts;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExtraBootPackages(List<String> extraBootPackages) {
        this.extraBootPackages = extraBootPackages;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setProvidedExclusions(List<String> providedExclusions) {
        this.providedExclusions = providedExclusions;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setProvidedInclusions(List<String> providedInclusions) {
        this.providedInclusions = providedInclusions;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setTestExclusions(List<String> testExclusions) {
        this.testExclusions = testExclusions;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setTestInclusions(List<String> testInclusions) {
        this.testInclusions = testInclusions;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExportPluginClasses(List<Class> exportPluginClasses) {
        this.exportPluginClasses = exportPluginClasses;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setExtensionMetadataGeneration(boolean extensionMetadataGenerationEnabled) {
        this.extensionMetadataGenerationEnabled = extensionMetadataGenerationEnabled;
        return this;
    }

    public ArtifactIsolatedClassLoaderBuilder setApplicationUrls(List<URL> applicationUrls) {
        this.applicationUrls = applicationUrls;
        return this;
    }

    public ArtifactClassLoaderHolder build() {
        ClassPathClassifierContext context;
        Preconditions.checkNotNull((Object)this.rootArtifact, (String)"rootArtifact has to be set");
        Preconditions.checkNotNull((Object)this.classPathUrlProvider, (String)"classPathUrlProvider has to be set");
        Preconditions.checkNotNull((Object)this.classPathClassifier, (String)"classPathClassifier has to be set");
        try {
            context = new ClassPathClassifierContext(this.rootArtifact, this.pluginResourcesFolder, this.classPathUrlProvider.getURLs(), this.excludedArtifacts, this.extraBootPackages, this.providedExclusions, this.providedInclusions, this.testExclusions, this.testInclusions, this.pluginCoordinates, this.sharedPluginLibCoordinates, this.exportPluginClasses, this.applicationUrls, this.extensionMetadataGenerationEnabled);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating the classification context", e);
        }
        ArtifactsUrlClassification artifactsUrlClassification = this.classPathClassifier.classify(context);
        return this.isolatedClassLoaderFactory.createArtifactClassLoader(context.getExtraBootPackages(), artifactsUrlClassification);
    }

    private Artifact getRootArtifact(File rootArtifactClassesFolder) {
        File pomFile = new File(rootArtifactClassesFolder.getParentFile().getParentFile(), POM_XML);
        this.logger.debug("Reading rootArtifact from pom file: {}", (Object)pomFile);
        Model model = MavenModelFactory.createMavenProject(pomFile);
        return new DefaultArtifact(model.getGroupId() != null ? model.getGroupId() : model.getParent().getGroupId(), model.getArtifactId(), model.getPackaging(), model.getVersion() != null ? model.getVersion() : model.getParent().getVersion());
    }
}

