/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.test.runner.api.ArtifactClassificationType;
import org.mule.test.runner.api.DependencyResolver;

public class ArtifactClassificationTypeResolver {
    private static final String MULE_EXTENSION_CLASSIFIER = "mule-extension";
    private static final String MULE_MODULE_PROPERTIES = "META-INF/mule-module.properties";
    private static final String PLUGIN_PROPERTIES = "plugin.properties";
    private static final String JAR_EXTENSION = "jar";
    private DependencyResolver dependencyResolver;

    public ArtifactClassificationTypeResolver(DependencyResolver dependencyResolver) {
        Preconditions.checkNotNull((Object)dependencyResolver, (String)"dependencyResolver cannot be null");
        this.dependencyResolver = dependencyResolver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArtifactClassificationType resolveArtifactClassificationType(Artifact artifact) {
        try (URLClassLoader artifactClassLoader = this.createArtifactClassLoader(artifact);){
            if (this.isMulePlugin(artifact, artifactClassLoader)) {
                ArtifactClassificationType artifactClassificationType = ArtifactClassificationType.PLUGIN;
                return artifactClassificationType;
            }
            if (this.isMuleModule(artifactClassLoader)) {
                ArtifactClassificationType artifactClassificationType = ArtifactClassificationType.MODULE;
                return artifactClassificationType;
            }
            ArtifactClassificationType artifactClassificationType = ArtifactClassificationType.APPLICATION;
            return artifactClassificationType;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean isMulePlugin(Artifact artifact, ClassLoader artifactClassLoader) {
        return artifact.getExtension().equals("mule-plugin") || artifact.getExtension().equals(MULE_EXTENSION_CLASSIFIER) || this.hasResource(artifactClassLoader, PLUGIN_PROPERTIES);
    }

    private boolean isMuleModule(ClassLoader artifactClassLoader) {
        return this.hasResource(artifactClassLoader, MULE_MODULE_PROPERTIES);
    }

    private boolean hasResource(ClassLoader classLoader, String resource) {
        if (classLoader == null) {
            return false;
        }
        return classLoader.getResource(resource) != null;
    }

    private URLClassLoader createArtifactClassLoader(Artifact artifact) {
        try {
            return new URLClassLoader(new URL[]{this.resolveRootArtifactUrls(artifact)}, null);
        }
        catch (ArtifactResolutionException e) {
            return null;
        }
    }

    private URL resolveRootArtifactUrls(Artifact artifact) throws ArtifactResolutionException {
        DefaultArtifact jarArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), JAR_EXTENSION, JAR_EXTENSION, artifact.getVersion());
        try {
            return this.dependencyResolver.resolveArtifact((Artifact)jarArtifact).getArtifact().getFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Couldn't generate the URL for artifact: " + artifact);
        }
    }
}

